﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMWCrypt.pas' rev: 37.00 (Windows)

#ifndef SMWCryptHPP
#define SMWCryptHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <System.SysUtils.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smwcrypt
{
//-- forward type declarations -----------------------------------------------
struct MD5Context;
struct TRC4Context;
struct SHA256Context;
struct AESContext;
//-- type declarations -------------------------------------------------------
typedef System::StaticArray<unsigned, 2> MD5Count;

typedef System::StaticArray<unsigned, 4> MD5State;

typedef System::StaticArray<unsigned, 16> MD5Block;

typedef System::StaticArray<System::Byte, 8> MD5CBits;

typedef System::StaticArray<System::Byte, 16> MD5Digest;

typedef System::StaticArray<System::Byte, 64> MD5Buffer;

struct DECLSPEC_DRECORD MD5Context
{
public:
	MD5State State;
	MD5Count Count;
	MD5Buffer Buffer;
};


struct DECLSPEC_DRECORD TRC4Context
{
public:
	System::StaticArray<System::Byte, 256> State;
	System::Byte x;
	System::Byte y;
};


typedef System::StaticArray<unsigned, 8> SHA256CBits;

typedef System::StaticArray<System::Byte, 64> SHA256Buffer;

typedef System::StaticArray<System::Byte, 32> SHA256Digest;

struct DECLSPEC_DRECORD SHA256Context
{
public:
	System::LongWord LenHi;
	System::LongWord LenLo;
	unsigned Index;
	SHA256CBits Hash;
	SHA256Buffer Buffer;
};


struct DECLSPEC_DRECORD AESContext
{
public:
	int nr;
	int *rk;
	System::StaticArray<int, 68> buf;
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE void __fastcall MD5Init(MD5Context &Context);
extern DELPHI_PACKAGE void __fastcall MD5Update(MD5Context &Context, char * Input, unsigned Length);
extern DELPHI_PACKAGE void __fastcall MD5Final(MD5Context &Context, MD5Digest &Digest);
extern DELPHI_PACKAGE bool __fastcall MD5Match(const MD5Digest &D1, const MD5Digest &D2);
extern DELPHI_PACKAGE void __fastcall RC4Init(TRC4Context &RC4, const System::Sysutils::TByteArray &Key, unsigned Length);
extern DELPHI_PACKAGE void __fastcall RC4Crypt3(TRC4Context &RC4, const void *Source, System::RawByteString &Dest, int Count);
extern DELPHI_PACKAGE void __fastcall RC4Crypt2(TRC4Context &RC4, const System::RawByteString Source, System::RawByteString &Dest, int Count);
extern DELPHI_PACKAGE void __fastcall RC4Crypt(TRC4Context &RC4, const void *Source, void *Dest, int Count);
extern DELPHI_PACKAGE void __fastcall RC4Done(TRC4Context &RC4);
extern DELPHI_PACKAGE void __fastcall SHA256Init(SHA256Context &Context);
extern DELPHI_PACKAGE void __fastcall SHA256Update(SHA256Context &Context, const void *Input, System::LongWord Length);
extern DELPHI_PACKAGE void __fastcall SHA256Final(SHA256Context &Context, SHA256Digest &Digest);
extern DELPHI_PACKAGE void __fastcall AES_SetKey_Dec(AESContext &Context, System::Sysutils::TByteArray &Key, int KeySize);
}	/* namespace Smwcrypt */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMWCRYPT)
using namespace Smwcrypt;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMWCryptHPP
