﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'MSWBase.pas' rev: 37.00 (Windows)

#ifndef MSWBaseHPP
#define MSWBaseHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <Winapi.Windows.hpp>
#include <System.Types.hpp>

//-- user supplied -----------------------------------------------------------

namespace Mswbase
{
//-- forward type declarations -----------------------------------------------
struct TWString;
class DELPHICLASS TWideStrings;
class DELPHICLASS TMSWBaseDocument;
//-- type declarations -------------------------------------------------------
typedef System::UnicodeString TSMWAbout;

struct DECLSPEC_DRECORD TWString
{
public:
	System::WideString WString;
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TWideStrings : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::WideString operator[](int Index) { return this->Strings[Index]; }
	
private:
	System::Classes::TList* FWideStringList;
	bool FSaveUnicode;
	virtual System::WideString __fastcall GetTextStr();
	System::WideString __fastcall Get(int Index);
	void __fastcall Put(int Index, const System::WideString S);
	System::UnicodeString __fastcall GetText();
	
public:
	__fastcall TWideStrings();
	__fastcall virtual ~TWideStrings();
	int __fastcall Count();
	void __fastcall Clear();
	int __fastcall Add(const System::WideString S);
	int __fastcall WideCompareText(const System::WideString S1, const System::WideString S2);
	int __fastcall IndexOf(const System::WideString S);
	int __fastcall IndexOfIgnoreCase(const System::WideString S);
	void __fastcall Insert(int Index, const System::WideString S);
	void __fastcall SaveToFile(const System::UnicodeString FileName);
	void __fastcall SaveToStream(System::Classes::TStream* Stream);
	__property System::WideString Strings[int Index] = {read=Get, write=Put/*, default*/};
	__property System::UnicodeString Text = {read=GetText};
	__property System::WideString WideText = {read=GetTextStr};
	__property bool SaveUnicode = {read=FSaveUnicode, write=FSaveUnicode, default=1};
};

#pragma pack(pop)

enum DECLSPEC_DENUM TMSTextFormating : unsigned char { tfPlainText, tfRTF, tfHTML };

typedef void __fastcall (__closure *TMSWTextChange)(System::TObject* Sender, System::WideString &AText);

enum DECLSPEC_DENUM TSMWordSysChar : unsigned char { scUnknown, scRowEnd, scColumnEnd, scParagraphEnd, scFieldBegin, scFieldMiddle, scFieldEnd, scTime, scDateTimePicture, scHyperlink, scTOC, scTOC_From_Range, scPage, scNumPages, scEmbed, scEditTime, scSpeicherdat, scDateIName, scTextField, scFieldAttributes, scIncludePicture, scEndOfPage };

typedef void __fastcall (__closure *TMSWordConvertSysCharEvent)(System::TObject* Sender, TSMWordSysChar SysChar, System::WideString Value, System::WideString &Result);

enum DECLSPEC_DENUM TSMWParseItem : unsigned char { wpiText, wpiVBA, wpiPictures, wpiSummaryInformation, wpiHiddenText };

typedef System::Set<TSMWParseItem, TSMWParseItem::wpiText, TSMWParseItem::wpiHiddenText> TSMWParseItems;

class PASCALIMPLEMENTATION TMSWBaseDocument : public System::Classes::TComponent
{
	typedef System::Classes::TComponent inherited;
	
private:
	TSMWAbout FAbout;
	System::UnicodeString FFileName;
	TWideStrings* FText;
	TMSTextFormating FTextFormating;
	int FMaxTextLength;
	TSMWParseItems FParseItems;
	bool FConvertSysCharacters;
	TMSWordConvertSysCharEvent FOnConvertSysChar;
	System::Classes::TNotifyEvent FOnBeforeExecute;
	System::Classes::TNotifyEvent FOnAfterExecute;
	TMSWTextChange FOnBeforeText;
	TMSWTextChange FOnAfterText;
	void __fastcall SetAbout(const TSMWAbout Value);
	void __fastcall SetFileName(System::UnicodeString Value);
	
protected:
	bool IsCancelExtract;
	virtual void __fastcall ClearInternalLists();
	virtual void __fastcall AddText(System::WideString Value, TWideStrings* Target);
	System::WideString __fastcall GetTextStart();
	System::WideString __fastcall GetTextFinish();
	virtual void __fastcall InternalLoadFromOLEStream(System::Classes::TStream* Stream);
	
public:
	__fastcall virtual TMSWBaseDocument(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TMSWBaseDocument();
	virtual void __fastcall LoadFromStream(System::Classes::TStream* Stream);
	virtual void __fastcall LoadFromOLEStream(System::Classes::TStream* Stream);
	virtual void __fastcall LoadFromFile(const System::WideString AFileName);
	void __fastcall Execute();
	virtual bool __fastcall IsPasswordProtected();
	__property TWideStrings* Text = {read=FText};
	__property TWideStrings* PlainText = {read=FText};
	
__published:
	__property TSMWAbout About = {read=FAbout, write=SetAbout, stored=false};
	__property System::UnicodeString FileName = {read=FFileName, write=SetFileName};
	__property TMSTextFormating TextFormating = {read=FTextFormating, write=FTextFormating, default=0};
	__property int MaxTextLength = {read=FMaxTextLength, write=FMaxTextLength, default=0};
	__property TSMWParseItems ParseItems = {read=FParseItems, write=FParseItems, default=9};
	__property bool ConvertSysCharacters = {read=FConvertSysCharacters, write=FConvertSysCharacters, default=1};
	__property TMSWordConvertSysCharEvent OnConvertSysChar = {read=FOnConvertSysChar, write=FOnConvertSysChar};
	__property System::Classes::TNotifyEvent OnBeforeExecute = {read=FOnBeforeExecute, write=FOnBeforeExecute};
	__property System::Classes::TNotifyEvent OnAfterExecute = {read=FOnAfterExecute, write=FOnAfterExecute};
	__property TMSWTextChange OnBeforeText = {read=FOnBeforeText, write=FOnBeforeText};
	__property TMSWTextChange OnAfterText = {read=FOnAfterText, write=FOnAfterText};
};


//-- var, const, procedure ---------------------------------------------------
#define SMWordVersion L"1.6 (b39)"
#define EWideStringsOutOfBounds L"WideStrings index out of bounds"
extern DELPHI_PACKAGE System::UnicodeString __fastcall GetHTMLFontSize(int Size);
}	/* namespace Mswbase */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_MSWBASE)
using namespace Mswbase;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// MSWBaseHPP
