﻿// CodeGear C++Builder
// Copyright (c) 1995, 2024 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'MSWOO.pas' rev: 36.00 (Windows)

#ifndef MSWOOHPP
#define MSWOOHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <MSWBase.hpp>
#include <MSW_Hdr.hpp>
#include <MSW_Sum.hpp>
#include <SMWXML.hpp>
#include <Winapi.Windows.hpp>
#include <Winapi.ActiveX.hpp>
#include <System.Win.ComObj.hpp>
#include <Vcl.Graphics.hpp>
#include <System.UITypes.hpp>
#include <System.Types.hpp>

//-- user supplied -----------------------------------------------------------

namespace Mswoo
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TOOStyle;
class DELPHICLASS TOOStyleText;
class DELPHICLASS TOOStyleGraphic;
class DELPHICLASS TOOStyleNumList;
class DELPHICLASS TOOStyles;
class DELPHICLASS TCustomOpenOfficeDocument;
class DELPHICLASS TOpenOfficeTextDocument;
class DELPHICLASS TOpenOfficeSpreadsheet;
class DELPHICLASS TOpenOfficePresentation;
//-- type declarations -------------------------------------------------------
#pragma pack(push,4)
class PASCALIMPLEMENTATION TOOStyle : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	System::UnicodeString FStyleName;
	System::UnicodeString FStyleFamily;
	TOOStyle* FStyleParent;
	
public:
	__fastcall virtual TOOStyle(System::Classes::TComponent* AOwner);
	
__published:
	__property System::UnicodeString StyleFamily = {read=FStyleFamily, write=FStyleFamily};
	__property System::UnicodeString StyleName = {read=FStyleName, write=FStyleName};
	__property TOOStyle* StyleParent = {read=FStyleParent, write=FStyleParent};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TOOStyle() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TOOStyleText : public TOOStyle
{
	typedef TOOStyle inherited;
	
private:
	Vcl::Graphics::TFont* FTextFont;
	System::Uitypes::TColor FColor;
	System::Classes::TAlignment FAlignment;
	void __fastcall SetTextFont(Vcl::Graphics::TFont* Value);
	System::Uitypes::TColor __fastcall GetTextColor();
	void __fastcall SetTextColor(System::Uitypes::TColor Value);
	
public:
	__fastcall virtual TOOStyleText(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TOOStyleText();
	
__published:
	__property Vcl::Graphics::TFont* TextFont = {read=FTextFont, write=SetTextFont};
	__property System::Uitypes::TColor TextColor = {read=GetTextColor, write=SetTextColor, default=0};
	__property System::Classes::TAlignment Alignment = {read=FAlignment, write=FAlignment, default=0};
	__property System::Uitypes::TColor Color = {read=FColor, write=FColor, default=16777215};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TOOStyleGraphic : public TOOStyle
{
	typedef TOOStyle inherited;
	
private:
	Winapi::Windows::TRect FClipRect;
	
public:
	__property Winapi::Windows::TRect ClipRect = {read=FClipRect, write=FClipRect};
public:
	/* TOOStyle.Create */ inline __fastcall virtual TOOStyleGraphic(System::Classes::TComponent* AOwner) : TOOStyle(AOwner) { }
	
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TOOStyleGraphic() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TOOStyleNumList : public TOOStyle
{
	typedef TOOStyle inherited;
	
private:
	System::UnicodeString FNumPrefix;
	System::UnicodeString FNumSufix;
	System::UnicodeString FNumFormat;
	int FSpaceBefore;
	System::UnicodeString FBulletChar;
	
public:
	__fastcall virtual TOOStyleNumList(System::Classes::TComponent* AOwner);
	
__published:
	__property System::UnicodeString NumPrefix = {read=FNumPrefix, write=FNumPrefix};
	__property System::UnicodeString NumSufix = {read=FNumSufix, write=FNumSufix};
	__property System::UnicodeString NumFormat = {read=FNumFormat, write=FNumFormat};
	__property int SpaceBefore = {read=FSpaceBefore, write=FSpaceBefore, nodefault};
	__property System::UnicodeString BulletChar = {read=FBulletChar, write=FBulletChar};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TOOStyleNumList() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TOOStyles : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	__fastcall virtual ~TOOStyles();
	void __fastcall ClearStyles();
	TOOStyle* __fastcall GetStyle(int AIndex);
	TOOStyle* __fastcall FindByStyleName(const System::UnicodeString AStyleName);
public:
	/* TObject.Create */ inline __fastcall TOOStyles() : System::Classes::TList() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TCustomOpenOfficeDocument : public Mswbase::TMSWBaseDocument
{
	typedef Mswbase::TMSWBaseDocument inherited;
	
private:
	Msw_sum::TSMWordSummaryInformation* FSummaryInformation;
	TOOStyles* FStyles;
	void __fastcall SetSummaryInformation(Msw_sum::TSMWordSummaryInformation* Value);
	
protected:
	System::UnicodeString FXMLTagRoot;
	System::UnicodeString FXMLTagText;
	virtual void __fastcall ClearInternalLists();
	void __fastcall ContentTagHandler(System::TObject* Sender, Smwxml::TSMXMLItem* ParentNode, System::UnicodeString ATagName, System::UnicodeString ATagValue, System::UnicodeString ATagAttributes, bool &Accept);
	void __fastcall LoadXMLFilePart(System::Classes::TStream* Stream, Mswbase::TWideStrings* List);
	
public:
	__fastcall virtual TCustomOpenOfficeDocument(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TCustomOpenOfficeDocument();
	virtual void __fastcall LoadFromStream(System::Classes::TStream* Stream);
	virtual void __fastcall LoadFromFile(const System::WideString AFileName);
	__property TOOStyles* Styles = {read=FStyles};
	
__published:
	__property Msw_sum::TSMWordSummaryInformation* SummaryInformation = {read=FSummaryInformation, write=SetSummaryInformation};
};


class PASCALIMPLEMENTATION TOpenOfficeTextDocument : public TCustomOpenOfficeDocument
{
	typedef TCustomOpenOfficeDocument inherited;
	
public:
	__fastcall virtual TOpenOfficeTextDocument(System::Classes::TComponent* AOwner);
public:
	/* TCustomOpenOfficeDocument.Destroy */ inline __fastcall virtual ~TOpenOfficeTextDocument() { }
	
};


class PASCALIMPLEMENTATION TOpenOfficeSpreadsheet : public TCustomOpenOfficeDocument
{
	typedef TCustomOpenOfficeDocument inherited;
	
public:
	__fastcall virtual TOpenOfficeSpreadsheet(System::Classes::TComponent* AOwner);
public:
	/* TCustomOpenOfficeDocument.Destroy */ inline __fastcall virtual ~TOpenOfficeSpreadsheet() { }
	
};


class PASCALIMPLEMENTATION TOpenOfficePresentation : public TCustomOpenOfficeDocument
{
	typedef TCustomOpenOfficeDocument inherited;
	
public:
	__fastcall virtual TOpenOfficePresentation(System::Classes::TComponent* AOwner);
public:
	/* TCustomOpenOfficeDocument.Destroy */ inline __fastcall virtual ~TOpenOfficePresentation() { }
	
};


//-- var, const, procedure ---------------------------------------------------
}	/* namespace Mswoo */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_MSWOO)
using namespace Mswoo;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// MSWOOHPP
