unit Main;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ComCtrls;

type
  TfrmMain = class(TForm)
    Button1: TButton;
    RichEdit1: TRichEdit;
    OpenDialog1: TOpenDialog;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}
uses SMWPDF;

function GetDocText(const AFileName: string): string;
var
   PDFReader: TSMPDFReader;
begin
   Result := '';
   PDFReader := TSMPDFReader.Create(nil);
   try
     PDFReader.FileName := AFileName;
     PDFReader.Execute;
     Result := PDFReader.PlainText.Text;
//     PDFReader.PlainText.SaveToFile(ChangeFileExt(AFileName, '.txt'));
   finally
     PDFReader.Free;
   end;
end;

procedure TfrmMain.Button1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
    RichEdit1.Lines.Text := GetDocText(OpenDialog1.FileName)
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  OpenDialog1.FileName := ExtractFilePath(Application.ExeName)+'sample.pdf';
end;

end.
