﻿// CodeGear C++Builder
// Copyright (c) 1995, 2024 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMWPDF.pas' rev: 36.00 (Windows)

#ifndef SMWPDFHPP
#define SMWPDFHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <Winapi.Windows.hpp>
#include <System.SysUtils.hpp>
#include <MSWBase.hpp>
#include <MSW_Sum.hpp>
#include <SMWCrypt.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smwpdf
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMPDFFont;
class DELPHICLASS TSMPDFFonts;
class DELPHICLASS TSMPDFItem;
class DELPHICLASS TSMPDFItemText;
class DELPHICLASS TSMPDFItemImage;
class DELPHICLASS TSMPDFItemForm;
class DELPHICLASS TSMPDFItems;
class DELPHICLASS TSMPDFPage;
class DELPHICLASS TSMPDFPages;
class DELPHICLASS TSMPDFEncryption;
class DELPHICLASS TSMPDFStandardEncryption;
class DELPHICLASS TSMPDFStandardAlgorithm12;
class DELPHICLASS TSMPDFCryptFilter;
class DELPHICLASS TSMPDFStandardCryptFilter;
class DELPHICLASS TSMPDFXRef;
class DELPHICLASS TSMPDFXRefList;
class DELPHICLASS TSMPDFReader;
class DELPHICLASS TSMWLZWDecoder;
//-- type declarations -------------------------------------------------------
#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMPDFFont : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	System::UnicodeString FFontName;
	System::UnicodeString FContent;
	System::UnicodeString FEncoding;
	System::UnicodeString FCMap;
	System::UnicodeString FDifferencies;
	System::UnicodeString FCID;
	bool FIdentity;
	System::UnicodeString FDescendantFonts;
	System::UnicodeString FFontDescriptor;
	System::UnicodeString FFontFile;
	System::UnicodeString FFontFile2;
	System::UnicodeString FFontFile3;
	System::UnicodeString FCIDToGIDMap;
	System::UnicodeString FCIDSystemInfo;
	void __fastcall SetCMap(System::UnicodeString Value);
	void __fastcall SetDifferencies(System::UnicodeString Value);
	
protected:
	System::Classes::TStrings* lstBFRange;
	System::Classes::TStrings* lstBFChars;
	System::Classes::TStrings* lstCodeSpaceRange;
	System::Classes::TStrings* lstDifferencies;
	
public:
	__fastcall virtual TSMPDFFont();
	__fastcall virtual ~TSMPDFFont();
	System::WideString __fastcall ConvertCID(bool AddSpace, const System::RawByteString AValue);
	System::WideString __fastcall ConvertCMap(bool IsUnicode, bool AddSpace, const System::RawByteString AValue);
	System::WideString __fastcall ConvertDifferencies(const System::WideString AValue);
	
__published:
	__property System::UnicodeString FontName = {read=FFontName, write=FFontName};
	__property System::UnicodeString Content = {read=FContent, write=FContent};
	__property System::UnicodeString Encoding = {read=FEncoding, write=FEncoding};
	__property System::UnicodeString CMap = {read=FCMap, write=SetCMap};
	__property System::UnicodeString CID = {read=FCID, write=FCID};
	__property System::UnicodeString Differencies = {read=FDifferencies, write=SetDifferencies};
	__property bool Identity = {read=FIdentity, write=FIdentity, default=0};
	__property System::UnicodeString DescendantFonts = {read=FDescendantFonts, write=FDescendantFonts};
	__property System::UnicodeString FontDescriptor = {read=FFontDescriptor, write=FFontDescriptor};
	__property System::UnicodeString FontFile = {read=FFontFile, write=FFontFile};
	__property System::UnicodeString FontFile2 = {read=FFontFile2, write=FFontFile2};
	__property System::UnicodeString FontFile3 = {read=FFontFile3, write=FFontFile3};
	__property System::UnicodeString CIDToGIDMap = {read=FCIDToGIDMap, write=FCIDToGIDMap};
	__property System::UnicodeString CIDSystemInfo = {read=FCIDSystemInfo, write=FCIDSystemInfo};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMPDFFonts : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	__fastcall virtual TSMPDFFonts(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMPDFFonts();
	TSMPDFFont* __fastcall GetItem(int Index);
	TSMPDFFont* __fastcall AddItem();
	TSMPDFFont* __fastcall FindFontByName(const System::UnicodeString AFontName);
	virtual void __fastcall Clear();
};

#pragma pack(pop)

enum DECLSPEC_DENUM TSMPDFItemType : unsigned char { itUnknown, itText, itImage, itLine, itForm };

class PASCALIMPLEMENTATION TSMPDFItem : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TSMPDFItemType FItemType;
	System::UnicodeString FItemName;
	System::UnicodeString FFontName;
	int FFontSize;
	double FLeft;
	double FTop;
	
__published:
	__property System::UnicodeString FontName = {read=FFontName, write=FFontName};
	__property int FontSize = {read=FFontSize, write=FFontSize, nodefault};
	__property TSMPDFItemType ItemType = {read=FItemType, write=FItemType, default=0};
	__property System::UnicodeString ItemName = {read=FItemName, write=FItemName};
	__property double Left = {read=FLeft, write=FLeft};
	__property double Top = {read=FTop, write=FTop};
public:
	/* TObject.Create */ inline __fastcall TSMPDFItem() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TSMPDFItem() { }
	
};


class PASCALIMPLEMENTATION TSMPDFItemText : public TSMPDFItem
{
	typedef TSMPDFItem inherited;
	
private:
	System::WideString FText;
	bool FIsContinueBlock;
	
__published:
	__property System::WideString Text = {read=FText, write=FText};
	__property ItemType = {default=1};
	__property bool IsContinueBlock = {read=FIsContinueBlock, write=FIsContinueBlock, nodefault};
public:
	/* TObject.Create */ inline __fastcall TSMPDFItemText() : TSMPDFItem() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TSMPDFItemText() { }
	
};


class PASCALIMPLEMENTATION TSMPDFItemImage : public TSMPDFItem
{
	typedef TSMPDFItem inherited;
	
private:
	int FBitsPerComponent;
	bool FImageMask;
	int FHeight;
	int FWidth;
	System::RawByteString FData;
	
__published:
	__property System::RawByteString Data = {read=FData, write=FData};
	__property int BitsPerComponent = {read=FBitsPerComponent, write=FBitsPerComponent, nodefault};
	__property bool ImageMask = {read=FImageMask, write=FImageMask, nodefault};
	__property int Height = {read=FHeight, write=FHeight, nodefault};
	__property int Width = {read=FWidth, write=FWidth, nodefault};
	__property ItemType = {default=2};
public:
	/* TObject.Create */ inline __fastcall TSMPDFItemImage() : TSMPDFItem() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TSMPDFItemImage() { }
	
};


class PASCALIMPLEMENTATION TSMPDFItemForm : public TSMPDFItem
{
	typedef TSMPDFItem inherited;
	
private:
	System::RawByteString FData;
	
__published:
	__property System::RawByteString Data = {read=FData, write=FData};
	__property ItemType = {default=4};
public:
	/* TObject.Create */ inline __fastcall TSMPDFItemForm() : TSMPDFItem() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TSMPDFItemForm() { }
	
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMPDFItems : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	__fastcall virtual TSMPDFItems();
	__fastcall virtual ~TSMPDFItems();
	TSMPDFItem* __fastcall GetItem(int Index);
	TSMPDFItem* __fastcall AddItem(TSMPDFItemType ItemType);
	void __fastcall SortItems();
	virtual void __fastcall Clear();
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMPDFPage : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TSMPDFItems* FItems;
	int FLeft;
	int FTop;
	int FWidth;
	int FHeight;
	System::UnicodeString __fastcall GetPlainText();
	
public:
	__fastcall virtual TSMPDFPage();
	__fastcall virtual ~TSMPDFPage();
	void __fastcall ParseContents(TSMPDFReader* APDFReader, const System::RawByteString strContent, const System::RawByteString strMediaBox);
	__property System::UnicodeString PlainText = {read=GetPlainText};
	__property TSMPDFItems* Items = {read=FItems};
	
__published:
	__property int Left = {read=FLeft, write=FLeft, nodefault};
	__property int Top = {read=FTop, write=FTop, nodefault};
	__property int Width = {read=FWidth, write=FWidth, nodefault};
	__property int Height = {read=FHeight, write=FHeight, nodefault};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMPDFPages : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
private:
	System::UnicodeString __fastcall GetPlainText();
	
public:
	__fastcall virtual TSMPDFPages(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMPDFPages();
	TSMPDFPage* __fastcall GetPage(int Index);
	TSMPDFPage* __fastcall AddPage();
	virtual void __fastcall Clear();
	__property System::UnicodeString PlainText = {read=GetPlainText};
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMPDFEncryption : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	bool FEnabled;
	
public:
	virtual System::RawByteString __fastcall DecryptStream(int ContentID, System::RawByteString DocID, System::RawByteString Password, System::RawByteString Value);
	virtual bool __fastcall CheckAuthentication(System::RawByteString DocID, System::RawByteString Password);
	
__published:
	__property bool Enabled = {read=FEnabled, write=FEnabled, default=0};
public:
	/* TObject.Create */ inline __fastcall TSMPDFEncryption() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TSMPDFEncryption() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMPDFStandardEncryption : public TSMPDFEncryption
{
	typedef TSMPDFEncryption inherited;
	
private:
	int FAlgorithm;
	int FKeyLength;
	int FRevision;
	System::RawByteString FOwnerPasswordHash;
	System::RawByteString FUserPasswordHash;
	unsigned FPermissions;
	bool FEncryptMetadata;
	
public:
	bool __fastcall CanPrintDocument();
	bool __fastcall CanModifyDocument();
	bool __fastcall CanExtractContent();
	bool __fastcall CanModifyAnnotations();
	bool __fastcall CanFillInForm();
	bool __fastcall CanFormFieldFill2();
	bool __fastcall CanContentCopy2();
	bool __fastcall CanContentAccessibility();
	bool __fastcall CanPrintDocumentHighLevel();
	
__published:
	__property int Algorithm = {read=FAlgorithm, write=FAlgorithm, nodefault};
	__property int KeyLength = {read=FKeyLength, write=FKeyLength, default=40};
	__property int Revision = {read=FRevision, write=FRevision, nodefault};
	__property System::RawByteString OwnerPasswordHash = {read=FOwnerPasswordHash, write=FOwnerPasswordHash};
	__property System::RawByteString UserPasswordHash = {read=FUserPasswordHash, write=FUserPasswordHash};
	__property unsigned Permissions = {read=FPermissions, write=FPermissions, nodefault};
	__property bool EncryptMetadata = {read=FEncryptMetadata, write=FEncryptMetadata, default=1};
public:
	/* TObject.Create */ inline __fastcall TSMPDFStandardEncryption() : TSMPDFEncryption() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TSMPDFStandardEncryption() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMPDFStandardAlgorithm12 : public TSMPDFStandardEncryption
{
	typedef TSMPDFStandardEncryption inherited;
	
private:
	System::Sysutils::TByteArray LastComputedKey;
	System::RawByteString __fastcall PASSWORD_PADDING();
	System::RawByteString __fastcall GetPaddedPassword(System::RawByteString APassword, int ALength);
	
protected:
	void __fastcall ComputeKey(System::RawByteString DocID, System::RawByteString APassword, System::Sysutils::TByteArray &Key);
	void __fastcall ComputeKeyR5(System::RawByteString DocID, System::RawByteString APassword, bool IsOwnerKey, System::Sysutils::TByteArray &Key);
	System::RawByteString __fastcall ComputeUserPassword(System::RawByteString DocID, System::RawByteString APassword);
	System::RawByteString __fastcall ComputeOwnerPassword(System::RawByteString DocID, System::RawByteString APassword);
	
public:
	virtual System::RawByteString __fastcall DecryptStream(int ContentID, System::RawByteString DocID, System::RawByteString Password, System::RawByteString Value);
	virtual bool __fastcall CheckAuthentication(System::RawByteString DocID, System::RawByteString Password);
public:
	/* TObject.Create */ inline __fastcall TSMPDFStandardAlgorithm12() : TSMPDFStandardEncryption() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TSMPDFStandardAlgorithm12() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMPDFCryptFilter : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	System::UnicodeString FCFM;
	System::UnicodeString FAuthEvent;
	int FLength;
	
__published:
	__property System::UnicodeString CFM = {read=FCFM, write=FCFM};
	__property System::UnicodeString AuthEvent = {read=FAuthEvent, write=FAuthEvent};
	__property int Length = {read=FLength, write=FLength, nodefault};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMPDFCryptFilter() { }
	
public:
	/* TObject.Create */ inline __fastcall TSMPDFCryptFilter() : System::Classes::TPersistent() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMPDFStandardCryptFilter : public TSMPDFStandardEncryption
{
	typedef TSMPDFStandardEncryption inherited;
	
private:
	TSMPDFCryptFilter* FCF;
	System::UnicodeString FStmF;
	System::UnicodeString FStrF;
	System::UnicodeString FEFF;
	void __fastcall SetCF(TSMPDFCryptFilter* AValue);
	
public:
	__fastcall virtual TSMPDFStandardCryptFilter();
	__fastcall virtual ~TSMPDFStandardCryptFilter();
	virtual System::RawByteString __fastcall DecryptStream(int ContentID, System::RawByteString DocID, System::RawByteString Password, System::RawByteString Value);
	virtual bool __fastcall CheckAuthentication(System::RawByteString DocID, System::RawByteString Password);
	
__published:
	__property TSMPDFCryptFilter* CF = {read=FCF, write=SetCF};
	__property System::UnicodeString StmF = {read=FStmF, write=FStmF};
	__property System::UnicodeString StrF = {read=FStrF, write=FStrF};
	__property System::UnicodeString EFF = {read=FEFF, write=FEFF};
};

#pragma pack(pop)

enum DECLSPEC_DENUM TSMPDFXRefKind : unsigned char { xrkFree, xrkUnCompressed, xrkCompressed };

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMPDFXRef : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TSMPDFXRefKind FKind;
	int FOffset;
	int FObjNumber;
	
__published:
	__property TSMPDFXRefKind Kind = {read=FKind, write=FKind, default=0};
	__property int Offset = {read=FOffset, write=FOffset, nodefault};
	__property int ObjNumber = {read=FObjNumber, write=FObjNumber, nodefault};
public:
	/* TObject.Create */ inline __fastcall TSMPDFXRef() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TSMPDFXRef() { }
	
};

#pragma pack(pop)

#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMPDFXRefList : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
public:
	__fastcall virtual ~TSMPDFXRefList();
	TSMPDFXRef* __fastcall GetItem(int Index);
	TSMPDFXRef* __fastcall AddItem(int Index);
	int __fastcall GetOffsetForXRef(int Index);
	virtual void __fastcall Clear();
public:
	/* TObject.Create */ inline __fastcall TSMPDFXRefList() : System::Classes::TList() { }
	
};

#pragma pack(pop)

class PASCALIMPLEMENTATION TSMPDFReader : public Mswbase::TMSWBaseDocument
{
	typedef Mswbase::TMSWBaseDocument inherited;
	
private:
	TSMPDFXRefList* FXRefs;
	TSMPDFFonts* FFonts;
	TSMPDFPages* FPages;
	System::RawByteString FDocID;
	System::RawByteString FVersion;
	System::RawByteString FPassword;
	Msw_sum::TSMWordSummaryInformation* FSummaryInformation;
	void __fastcall SetSummaryInformation(Msw_sum::TSMWordSummaryInformation* Value);
	System::UnicodeString __fastcall Reverse(System::UnicodeString S);
	
protected:
	int StartCrossRef;
	System::RawByteString RootTag;
	System::RawByteString InfoTag;
	System::RawByteString EncryptTag;
	TSMPDFEncryption* Encryption;
	System::RawByteString __fastcall GetItemType(const System::RawByteString ALine);
	System::RawByteString __fastcall GetItemSubType(const System::RawByteString ALine);
	System::RawByteString __fastcall GetFilterContent(System::Classes::TStream* AStream, const System::RawByteString ALine, System::RawByteString &strFilter, int &intLength, int &intLength1);
	System::RawByteString __fastcall GetRefBody(const System::RawByteString Source, const System::RawByteString Ref, bool SearchFromEnd);
	System::RawByteString __fastcall GetDoubleBracketValue(System::Classes::TStream* AStream, const System::UnicodeString ATagName, const System::UnicodeString AValue);
	System::RawByteString __fastcall GetBodyByRefNo(System::Classes::TStream* strm, int RefNo);
	System::RawByteString __fastcall GetLastLine(System::RawByteString &s, int MaxLen, bool IsDelete);
	System::RawByteString __fastcall DecodeContentByFilter(const System::RawByteString AFilterDecode, System::RawByteString strCompressed, int ALength, int &ALength1, int ColumnCount, int Predictor);
	System::RawByteString __fastcall GetStreamContent(System::RawByteString AFilterDecode, System::RawByteString ALine, int ALength, int &ALength1, int ContentID);
	virtual void __fastcall ClearInternalLists();
	void __fastcall ParseEncryption(System::Classes::TStream* strm);
	System::RawByteString __fastcall GetInfoTag(const System::RawByteString ATagName, const System::RawByteString AValue, bool DecodeHex, bool ExtractBrackets);
	void __fastcall ReadFonts(System::Classes::TStream* AStream, System::RawByteString strFonts);
	void __fastcall ReadXObject(TSMPDFPage* CurrentPage, System::Classes::TStream* AStream, System::RawByteString strResources);
	void __fastcall ProcessPages(System::Classes::TStream* AStream, System::RawByteString strTag);
	void __fastcall LoadCrossXRefStream(System::Classes::TStream* AStream, const System::RawByteString XRefStreamTag, System::RawByteString strPDF);
	void __fastcall LoadCrossXRefTable(const System::RawByteString PrevTag, const System::RawByteString strPDF, System::RawByteString &strTag);
	void __fastcall ProcessMetaData(System::Classes::TStream* AStream);
	
public:
	__fastcall virtual TSMPDFReader(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMPDFReader();
	virtual void __fastcall LoadFromStream(System::Classes::TStream* AStream);
	virtual void __fastcall LoadFromFile(const System::WideString AFileName);
	__property TSMPDFXRefList* XRefs = {read=FXRefs};
	__property TSMPDFFonts* Fonts = {read=FFonts};
	__property TSMPDFPages* Pages = {read=FPages};
	__property System::RawByteString Version = {read=FVersion};
	
__published:
	__property System::RawByteString DocID = {read=FDocID, write=FDocID};
	__property System::RawByteString Password = {read=FPassword, write=FPassword};
	__property Msw_sum::TSMWordSummaryInformation* SummaryInformation = {read=FSummaryInformation, write=SetSummaryInformation};
};


#pragma pack(push,4)
class PASCALIMPLEMENTATION TSMWLZWDecoder : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	void __fastcall DecodeGIF(void * &Source, void * &Dest, int PackedSize, int UnpackedSize);
	void __fastcall DecodeTIFF(void * &Source, void * &Dest, int PackedSize, int UnpackedSize);
public:
	/* TObject.Create */ inline __fastcall TSMWLZWDecoder() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TSMWLZWDecoder() { }
	
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
}	/* namespace Smwpdf */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMWPDF)
using namespace Smwpdf;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMWPDFHPP
