﻿// CodeGear C++Builder
// Copyright (c) 1995, 2024 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'MSWord.pas' rev: 36.00 (Windows)

#ifndef MSWordHPP
#define MSWordHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <MSWBase.hpp>
#include <MSW_Hdr.hpp>
#include <MSW_Sum.hpp>
#include <Winapi.Windows.hpp>
#include <Winapi.ActiveX.hpp>
#include <System.Win.ComObj.hpp>
#include <System.Types.hpp>
#include <SMWXML.hpp>
#include <SMWUtils.hpp>

//-- user supplied -----------------------------------------------------------

namespace Msword
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TMSCustomWordDocument;
class DELPHICLASS TMSWordDocument;
class DELPHICLASS TMSWordXDocument;
//-- type declarations -------------------------------------------------------
typedef void __fastcall (__closure *TMSWordGetDefaultLanguage)(System::TObject* Sender, System::Word &DocLang);

enum DECLSPEC_DENUM TMSWRecordKind : unsigned char { DocBegin, DocEnd, SectionBegin, SectionEnd, ParaBegin, ParaEnd, CharPropBegin, CharPropEnd, CommentBegin, CommentEnd };

class PASCALIMPLEMENTATION TMSCustomWordDocument : public Mswbase::TMSWBaseDocument
{
	typedef Mswbase::TMSWBaseDocument inherited;
	
private:
	Mswbase::TWideStrings* FMacroText;
	Mswbase::TWideStrings* FFootNoteText;
	Mswbase::TWideStrings* FHeaderText;
	Mswbase::TWideStrings* FFooterText;
	Mswbase::TWideStrings* FAnnotationText;
	Mswbase::TWideStrings* FEndNoteText;
	Mswbase::TWideStrings* FTextBoxText;
	Msw_sum::TSMWordSummaryInformation* FSummaryInformation;
	System::UnicodeString FVBAProject;
	System::UnicodeString FVBAMacroSource;
	void __fastcall SetSummaryInformation(Msw_sum::TSMWordSummaryInformation* Value);
	void __fastcall ClearVBAProjectItems();
	
protected:
	virtual void __fastcall ClearInternalLists();
	
public:
	Msw_hdr::TVBAProjectItems* VBAProjectItems;
	__fastcall virtual TMSCustomWordDocument(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TMSCustomWordDocument();
	__property Mswbase::TWideStrings* MacroText = {read=FMacroText};
	__property Mswbase::TWideStrings* FootNoteText = {read=FFootNoteText};
	__property Mswbase::TWideStrings* HeaderText = {read=FHeaderText};
	__property Mswbase::TWideStrings* FooterText = {read=FFooterText, write=FFooterText};
	__property Mswbase::TWideStrings* AnnotationText = {read=FAnnotationText};
	__property Mswbase::TWideStrings* EndNoteText = {read=FEndNoteText};
	__property Mswbase::TWideStrings* TextBoxText = {read=FTextBoxText};
	__property System::UnicodeString VBAProject = {read=FVBAProject};
	__property System::UnicodeString VBAMacroSource = {read=FVBAMacroSource};
	
__published:
	__property Msw_sum::TSMWordSummaryInformation* SummaryInformation = {read=FSummaryInformation, write=SetSummaryInformation};
};


class PASCALIMPLEMENTATION TMSWordDocument : public TMSCustomWordDocument
{
	typedef TMSCustomWordDocument inherited;
	
private:
	Msw_hdr::TFIB FIB;
	Msw_hdr::TCLX CLX;
	Msw_hdr::U32 wvCHPX_pn_previous;
	Msw_hdr::TCHPX_FKP wvCHPX_FKP_previous;
	int FDocVersion;
	System::WideString FLastFieldCode;
	int intFieldCodeLen;
	TMSWordGetDefaultLanguage FOnGetDefaultLanguage;
	int __fastcall GetIndexFCInFKP_PAPX(System::Classes::TList* lst, Msw_hdr::U8 cRun, Msw_hdr::U32 currentFC);
	void __fastcall InitPAP(const Msw_hdr::TPAP &apap);
	void __fastcall InitPAPFromIstd(Msw_hdr::TPAP &apap, Msw_hdr::U16 istdbase, const Msw_hdr::TSTSH &stsh);
	void __fastcall AddPAPXFromBucket(Msw_hdr::TPAP &apap, const Msw_hdr::TUPXF &upxf, const Msw_hdr::TSTSH &stsh);
	System::Word __fastcall DocLangToCodePage();
	
protected:
	Msw_hdr::U32 PAPX_pn_previous;
	Msw_hdr::TPAPX_FKP PAPX_FKP_previous;
	virtual void __fastcall ClearInternalLists();
	bool __fastcall IsComplexDocument();
	virtual void __fastcall AddText(System::WideString Value, Mswbase::TWideStrings* Target);
	void __fastcall LoadVBA(_di_IStorage Storage);
	void __fastcall DecompressMacros(_di_IStorage Storage);
	void __fastcall LoadIStorage(_di_IStorage Storage);
	void __fastcall ReadDocFromStream(System::Classes::TStream* Stream, System::Classes::TStream* ATableStream);
	System::WideString __fastcall ProcessSysCharacter(System::WideChar ch, bool IsLast, System::WideChar &chNext);
	int __fastcall GetPieceBoundsFC(unsigned &Start, unsigned &Finish, unsigned idxPiece);
	unsigned __fastcall GetNormFC(unsigned Value, void * &Flag);
	unsigned __fastcall ConvertCPToFC(unsigned curCP);
	unsigned __fastcall GetPieceFromCP(unsigned curCP);
	void __fastcall GetCHPX_FKP(Smwutils::TSMWOleStream* Stream, Msw_hdr::TCHPX_FKP &fkp, Msw_hdr::U32 pn);
	void __fastcall GetPAPX_FKP(Smwutils::TSMWOleStream* Stream, Msw_hdr::TPAPX_FKP &fkp, Msw_hdr::U32 pn);
	int __fastcall GetSimpleSectionBounds(Smwutils::TSMWOleStream* Stream, const Msw_hdr::TSEP &sep, unsigned fcFirst, unsigned fcLim, unsigned cp, Msw_hdr::TSEDs seds, unsigned &sPiece, System::Classes::TList* posSEDX, unsigned section_intervals, const Msw_hdr::TSTSH &stsh);
	void __fastcall BTE_PLCF(System::Classes::TStream* Stream, bool IsWord6, System::Classes::TList* &bte, System::Classes::TList* &pos, unsigned &intervals, unsigned offset, unsigned len);
	void __fastcall SED_PLCF(Smwutils::TSMWOleStream* Stream, System::Classes::TList* &sed, System::Classes::TList* &pos, unsigned &intervals, unsigned offset, unsigned len);
	int __fastcall BTE_FromFC(Msw_hdr::U32 &bte, Msw_hdr::U32 currentFC, System::Classes::TList* BTEs, System::Classes::TList* fcs, int noBTE);
	int __fastcall GetSimpleParaBounds(Smwutils::TSMWOleStream* Stream, Msw_hdr::TPAPX_FKP &fkp, Msw_hdr::U32 &fcFirst, Msw_hdr::U32 &fcLim, Msw_hdr::U32 currentFC, System::Classes::TList* &bte, System::Classes::TList* &pos, int noBTE);
	int __fastcall AssembleSimplePAP(Msw_hdr::TPAP &apap, Msw_hdr::U32 fc, const Msw_hdr::TPAPX_FKP &fkp, const Msw_hdr::TSTSH &stsh);
	void __fastcall GetIntervalBounds(Msw_hdr::U32 &fcFirst, Msw_hdr::U32 &fcLim, Msw_hdr::U32 currentfc, System::Classes::TList* rgfc, Msw_hdr::U32 nopos);
	void __fastcall ReadFIB(System::Classes::TStream* Stream);
	void __fastcall ReadCLX(System::Classes::TStream* Stream);
	void __fastcall ReadSimpleText(System::Classes::TStream* Stream);
	void __fastcall ReadComplexText(Smwutils::TSMWOleStream* Stream);
	void __fastcall HandleElement(TMSWRecordKind RecKind, const Msw_hdr::TPAP &apap, int para_dirty);
	
public:
	__fastcall virtual TMSWordDocument(System::Classes::TComponent* AOwner);
	virtual void __fastcall LoadFromStream(System::Classes::TStream* Stream);
	virtual void __fastcall LoadFromFile(const System::WideString AFileName);
	bool __fastcall IsFarEastDocument();
	virtual bool __fastcall IsPasswordProtected();
	bool __fastcall IsUseTableStream();
	
__published:
	__property int DocVersion = {read=FDocVersion, write=FDocVersion, nodefault};
	__property TMSWordGetDefaultLanguage OnGetDefaultLanguage = {read=FOnGetDefaultLanguage, write=FOnGetDefaultLanguage};
public:
	/* TMSCustomWordDocument.Destroy */ inline __fastcall virtual ~TMSWordDocument() { }
	
};


class PASCALIMPLEMENTATION TMSWordXDocument : public TMSCustomWordDocument
{
	typedef TMSCustomWordDocument inherited;
	
private:
	System::WideString FCurrentTextLine;
	Mswbase::TWideStrings* FcurList;
	bool IsHiddenText;
	bool FPasswordProtected;
	Mswbase::TWideStrings* FHeaderFileNamesToParse;
	Mswbase::TWideStrings* FFooterFileNamesToParse;
	
protected:
	void __fastcall LoadXMLFilePart(System::Classes::TStream* Stream, Mswbase::TWideStrings* List);
	virtual void __fastcall InternalLoadFromOLEStream(System::Classes::TStream* Stream);
	void __fastcall NewRowTag(System::TObject* Sender, Smwxml::TSMXMLItem* ParentNode, System::UnicodeString ATagName, System::UnicodeString ATagValue, System::UnicodeString ATagAttributes, bool &Accept);
	void __fastcall DeleteRowTag(System::TObject* Sender, Smwxml::TSMXMLItem* &Node, bool &Cancel);
	
public:
	__fastcall virtual TMSWordXDocument(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TMSWordXDocument();
	virtual void __fastcall LoadFromStream(System::Classes::TStream* Stream);
	virtual void __fastcall LoadFromFile(const System::WideString AFileName);
	virtual bool __fastcall IsPasswordProtected();
};


//-- var, const, procedure ---------------------------------------------------
}	/* namespace Msword */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_MSWORD)
using namespace Msword;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// MSWordHPP
