﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMRPars.pas' rev: 37.00 (Windows)

#ifndef SMRParsHPP
#define SMRParsHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <System.Classes.hpp>
#include <Data.DB.hpp>
#include <SMRTypes.hpp>
#include <SMRDMan.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smrpars
{
//-- forward type declarations -----------------------------------------------
struct SMCANExpr;
struct SMCANHdr;
struct TExprNode;
class DELPHICLASS TFilterExpr;
class DELPHICLASS TExprParser;
struct FMTBcd;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM SMCANOp : unsigned char { canNOTDEFINED, canISBLANK, canNOTBLANK, canEQ, canNE, canGT, canLT, canGE, canLE, canNOT, canAND, canOR, canFIELD2, canCONST2, canMINUS, canADD, canSUB, canMUL, canDIV, canMOD, canSUM, canCOUNT, canMIN, canMAX, canAVG, canLIKE, canIN, canFUNC2, canLISTELEM2, canASSIGN };

typedef SMCANOp *PSMCANOp;

enum DECLSPEC_DENUM SMNODEClass : unsigned char { nodeNULL, nodeUNARY, nodeBINARY, nodeCOMPARE, nodeFIELD, nodeCONST, nodeLIST, nodeFUNC, nodeLISTELEM };

typedef SMCANExpr *PSMCANExpr;

typedef PSMCANExpr *PPSMCANExpr;

#pragma pack(push,1)
struct DECLSPEC_DRECORD SMCANExpr
{
public:
	System::Word iVer;
	System::Word iTotalSize;
	System::Word iNodes;
	System::Word iNodeStart;
	System::Word iLiteralStart;
};
#pragma pack(pop)


typedef SMCANHdr *PSMCANHdr;

#pragma pack(push,1)
struct DECLSPEC_DRECORD SMCANHdr
{
public:
	SMNODEClass nodeClass;
	SMCANOp canOp;
};
#pragma pack(pop)


enum DECLSPEC_DENUM TExprNodeKind : unsigned char { enField, enConst, enOperator, enFunc };

enum DECLSPEC_DENUM TExprScopeKind : unsigned char { skField, skAgg, skConst };

typedef TExprNode *PExprNode;

struct DECLSPEC_DRECORD TExprNode
{
public:
	PExprNode FNext;
	TExprNodeKind FKind;
	bool FPartial;
	SMCANOp FOperator;
	System::Variant FData;
	PExprNode FLeft;
	PExprNode FRight;
	int FDataType;
	int FDataSize;
	System::Classes::TList* FArgs;
	TExprScopeKind FScopeKind;
};


typedef void __fastcall (__closure *TGetVariableEvent)(System::TObject* Sender, System::UnicodeString VariableName, bool &Accept, Data::Db::TFieldType &VariableType, System::Variant &Value);

class PASCALIMPLEMENTATION TFilterExpr : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TGetVariableEvent FVariableEvent;
	Smrdman::TSMRDataManager* FDataManager;
	Data::Db::TFilterOptions FOptions;
	PExprNode FNodes;
	PSMCANExpr FExprBuffer;
	int FExprBufSize;
	int FExprNodeSize;
	int FExprDataSize;
	Data::Db::TField* __fastcall FieldFromNode(PExprNode Node);
	System::WideChar * __fastcall GetExprData(int Pos, int Size);
	int __fastcall PutConstBCD(const System::Variant &Value, int Decimals);
	int __fastcall PutConstBool(const System::Variant &Value);
	int __fastcall PutConstDate(const System::Variant &Value);
	int __fastcall PutConstDateTime(const System::Variant &Value);
	int __fastcall PutConstFloat(const System::Variant &Value);
	int __fastcall PutConstInt(int DataType, const System::Variant &Value);
	int __fastcall PutConstNode(int DataType, System::WideChar * Data, int Size);
	int __fastcall PutConstStr(const System::UnicodeString Value);
	int __fastcall PutConstTime(const System::Variant &Value);
	int __fastcall PutData(System::WideChar * Data, int Size);
	int __fastcall PutExprNode(PExprNode Node, SMCANOp ParentOp);
	int __fastcall PutFieldNode(Data::Db::TField* Field, PExprNode Node);
	int __fastcall PutNode(SMNODEClass NodeType, SMCANOp OpType, int OpCount);
	void __fastcall SetNodeOp(int Node, int Index, int Data);
	int __fastcall PutConstant(PExprNode Node);
	
public:
	__fastcall TFilterExpr(Smrdman::TSMRDataManager* ADataManager, Data::Db::TFilterOptions Options, TGetVariableEvent AGetVariableEvent);
	__fastcall virtual ~TFilterExpr();
	PExprNode __fastcall NewCompareNode(Data::Db::TField* Field, SMCANOp Operator, const System::Variant &Value);
	PExprNode __fastcall NewNode(TExprNodeKind Kind, SMCANOp Operator, const System::Variant &Data, PExprNode Left, PExprNode Right);
	PSMCANExpr __fastcall GetFilterData(PExprNode Root);
	__property Smrdman::TSMRDataManager* DataManager = {write=FDataManager};
};


enum DECLSPEC_DENUM TExprToken : unsigned char { etEnd, etSymbol, etName, etLiteral, etLParen, etRParen, etEQ, etNE, etGE, etLE, etGT, etLT, etADD, etSUB, etMUL, etDIV, etComma, etLIKE, etISNULL, etISNOTNULL, etIN };

class PASCALIMPLEMENTATION TExprParser : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	TFilterExpr* FFilter;
	System::UnicodeString FText;
	System::WideChar *FSourcePtr;
	System::WideChar *FTokenPtr;
	System::UnicodeString FTokenString;
	System::UnicodeString FStrTrue;
	System::UnicodeString FStrFalse;
	TExprToken FToken;
	TExprToken FPrevToken;
	PSMCANExpr FFilterData;
	bool FNumericLit;
	int FDataSize;
	Smrdman::TSMRDataManager* FDataManager;
	void __fastcall NextToken();
	bool __fastcall NextTokenIsLParen();
	PExprNode __fastcall ParseExpr();
	PExprNode __fastcall ParseExpr2();
	PExprNode __fastcall ParseExpr3();
	PExprNode __fastcall ParseExpr4();
	PExprNode __fastcall ParseExpr5();
	PExprNode __fastcall ParseExpr6();
	PExprNode __fastcall ParseExpr7();
	System::UnicodeString __fastcall TokenName();
	bool __fastcall TokenSymbolIs(const System::UnicodeString S);
	bool __fastcall TokenSymbolIsFunc(const System::UnicodeString S);
	void __fastcall GetFuncResultInfo(PExprNode Node);
	void __fastcall TypeCheckArithOp(PExprNode Node);
	void __fastcall GetScopeKind(PExprNode Root, PExprNode Left, PExprNode Right);
	System::Variant __fastcall EvalNode(PExprNode Node);
	
public:
	__fastcall TExprParser(Smrdman::TSMRDataManager* ADataManager, const System::UnicodeString Text, Data::Db::TFilterOptions Options, TGetVariableEvent AGetVariableEvent);
	__fastcall virtual ~TExprParser();
	void __fastcall SetExprParams(const System::UnicodeString Text);
	System::Variant __fastcall Evaluate();
};


typedef FMTBcd *PFMTBcd;

#pragma pack(push,1)
struct DECLSPEC_DRECORD FMTBcd
{
public:
	System::Byte iPrecision;
	System::Byte iSignSpecialPlaces;
	System::StaticArray<System::Byte, 32> iFraction;
};
#pragma pack(pop)


//-- var, const, procedure ---------------------------------------------------
static _DELPHI_CONST System::Int8 fldUNKNOWN = System::Int8(0x0);
static _DELPHI_CONST System::Int8 fldZSTRING = System::Int8(0x1);
static _DELPHI_CONST System::Int8 fldDATE = System::Int8(0x2);
static _DELPHI_CONST System::Int8 fldBLOB = System::Int8(0x3);
static _DELPHI_CONST System::Int8 fldBOOL = System::Int8(0x4);
static _DELPHI_CONST System::Int8 fldINT16 = System::Int8(0x5);
static _DELPHI_CONST System::Int8 fldINT32 = System::Int8(0x6);
static _DELPHI_CONST System::Int8 fldFLOAT = System::Int8(0x7);
static _DELPHI_CONST System::Int8 fldBCD = System::Int8(0x8);
static _DELPHI_CONST System::Int8 fldBYTES = System::Int8(0x9);
static _DELPHI_CONST System::Int8 fldTIME = System::Int8(0xa);
static _DELPHI_CONST System::Int8 fldTIMESTAMP = System::Int8(0xb);
static _DELPHI_CONST System::Int8 fldUINT16 = System::Int8(0xc);
static _DELPHI_CONST System::Int8 fldUINT32 = System::Int8(0xd);
static _DELPHI_CONST System::Int8 fldFLOATIEEE = System::Int8(0xe);
static _DELPHI_CONST System::Int8 fldVARBYTES = System::Int8(0xf);
static _DELPHI_CONST System::Int8 fldLOCKINFO = System::Int8(0x10);
static _DELPHI_CONST System::Int8 fldCURSOR = System::Int8(0x11);
static _DELPHI_CONST System::Int8 fldINT64 = System::Int8(0x12);
static _DELPHI_CONST System::Int8 fldUINT64 = System::Int8(0x13);
static _DELPHI_CONST System::Int8 fldADT = System::Int8(0x14);
static _DELPHI_CONST System::Int8 fldARRAY = System::Int8(0x15);
static _DELPHI_CONST System::Int8 fldREF = System::Int8(0x16);
static _DELPHI_CONST System::Int8 fldTABLE = System::Int8(0x17);
static _DELPHI_CONST System::Int8 fldDATETIME = System::Int8(0x18);
static _DELPHI_CONST System::Int8 fldFMTBCD = System::Int8(0x19);
static _DELPHI_CONST System::Int8 fldWIDESTRING = System::Int8(0x1a);
static _DELPHI_CONST System::Int8 fldstORATIMESTAMP = System::Int8(0x27);
static _DELPHI_CONST System::Int8 fldstORAINTERVAL = System::Int8(0x28);
static _DELPHI_CONST System::Int8 fldSINGLE = System::Int8(0x1b);
static _DELPHI_CONST System::Int8 fldDATETIMEOFFSET = System::Int8(0x24);
static _DELPHI_CONST System::Int8 CANEXPRVERSION = System::Int8(0x2);
extern DELPHI_PACKAGE System::StaticArray<System::Byte, 53> FldTypeMap;
extern DELPHI_PACKAGE Data::Db::TField* __fastcall GetFieldByName(Smrdman::TSMRDataManager* DataManager, System::UnicodeString strName);
extern DELPHI_PACKAGE System::Variant __fastcall EvaluateValue(Smrdman::TSMRDataManager* DataManager, System::UnicodeString Expression, TGetVariableEvent AGetVariableEvent);
extern DELPHI_PACKAGE bool __fastcall ValueIsField(Smrdman::TSMRDataManager* DataManager, const System::UnicodeString Expression, TGetVariableEvent AGetVariableEvent);
extern DELPHI_PACKAGE System::Variant __fastcall GetCalculatedValue(Smrdman::TSMRDataManager* DataManager, const System::UnicodeString Expression, const System::UnicodeString Format, Smrtypes::TCalcType CalcType, const System::Variant &PrevValue, const System::Variant &CurValue, TGetVariableEvent AGetVariableEvent);
}	/* namespace Smrpars */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMRPARS)
using namespace Smrpars;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMRParsHPP
