﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMRExprt.pas' rev: 37.00 (Windows)

#ifndef SMRExprtHPP
#define SMRExprtHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <System.UITypes.hpp>
#include <System.Types.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smrexprt
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMProperty;
class DELPHICLASS TSMRExport;
class DELPHICLASS TSMRExportToText;
class DELPHICLASS TSMRExportToEMF;
class DELPHICLASS TSMRExportToWMF;
class DELPHICLASS TSMRExportToBMP;
class DELPHICLASS TSMRExportToTIFF;
class DELPHICLASS TSMRExportAttributes;
class DELPHICLASS TSMRExportToCSV;
class DELPHICLASS TSMRMFERecord;
class DELPHICLASS TSMRExportToSpreadsheet;
class DELPHICLASS TSMRExportToHTML;
class DELPHICLASS TSMRExportToXML;
class DELPHICLASS TSMRExportToExcel;
class DELPHICLASS TSMRExportToLotus;
class DELPHICLASS TSMRExportToQuattroPro;
class DELPHICLASS TSMRExportToRTF;
class DELPHICLASS TSMRPDFFont;
class DELPHICLASS TSMRPDFFonts;
class DELPHICLASS TSMRExportToPDF;
struct TSMRRegisterExport;
//-- type declarations -------------------------------------------------------
class PASCALIMPLEMENTATION TSMProperty : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	System::UnicodeString FAuthor;
	System::UnicodeString FTitle;
	System::UnicodeString FSubject;
	System::UnicodeString FKeywords;
	System::Classes::TStrings* FComments;
	void __fastcall SetComments(System::Classes::TStrings* Value);
	
public:
	__fastcall TSMProperty();
	__fastcall virtual ~TSMProperty();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property System::UnicodeString Author = {read=FAuthor, write=FAuthor};
	__property System::UnicodeString Title = {read=FTitle, write=FTitle};
	__property System::UnicodeString Subject = {read=FSubject, write=FSubject};
	__property System::UnicodeString Keywords = {read=FKeywords, write=FKeywords};
	__property System::Classes::TStrings* Comments = {read=FComments, write=SetComments};
};


typedef void __fastcall (__closure *TSMRMFEBeforeRecordEvent)(System::TObject* Sender, Winapi::Windows::PEnhMetaRecord EMFRecord, bool &Accept);

class PASCALIMPLEMENTATION TSMRExport : public System::Classes::TComponent
{
	typedef System::Classes::TComponent inherited;
	
private:
	int intOffsetX;
	int intOffsetY;
	TSMProperty* FProperties;
	System::Classes::TNotifyEvent FOnStartExecute;
	System::Classes::TNotifyEvent FOnEndExecute;
	System::Classes::TNotifyEvent FOnNewPage;
	TSMRMFEBeforeRecordEvent FOnRecord;
	System::UnicodeString __fastcall GetProductKey();
	void __fastcall SetProperties(TSMProperty* Value);
	
protected:
	System::UnicodeString FDestinationFileName;
	
public:
	int intPageWidth;
	int intPageHeight;
	int intTotalWidth;
	int intTotalHeight;
	__fastcall virtual TSMRExport(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMRExport();
	virtual void __fastcall StartExport();
	virtual void __fastcall EndExport();
	virtual void __fastcall NewPage(int APage, int ABar);
	virtual void __fastcall ExportEMF();
	virtual void __fastcall ExportEMFRecord(HDC DC, Winapi::Windows::PHandleTable HandleTable, Winapi::Windows::PEnhMetaRecord EMFRecord, int nObj, void * OptData);
	virtual void __fastcall SaveToFile(System::UnicodeString FileName);
	void __fastcall SaveMetafileToFile(Vcl::Graphics::TMetafile* mf, System::UnicodeString FileName);
	virtual void __fastcall PageProcessed(Vcl::Graphics::TMetafile* OriginalMetafile);
	__property System::UnicodeString ProductKey = {read=GetProductKey};
	
__published:
	__property int OffsetX = {read=intOffsetX, write=intOffsetX, nodefault};
	__property int OffsetY = {read=intOffsetY, write=intOffsetY, nodefault};
	__property TSMProperty* Properties = {read=FProperties, write=SetProperties};
	__property System::Classes::TNotifyEvent OnStartExecute = {read=FOnStartExecute, write=FOnStartExecute};
	__property System::Classes::TNotifyEvent OnEndExecute = {read=FOnEndExecute, write=FOnEndExecute};
	__property System::Classes::TNotifyEvent OnNewPage = {read=FOnNewPage, write=FOnNewPage};
	__property TSMRMFEBeforeRecordEvent OnRecord = {read=FOnRecord, write=FOnRecord};
};


_DECLARE_METACLASS(System::TMetaClass, TSMRExportClass);

class PASCALIMPLEMENTATION TSMRExportToText : public TSMRExport
{
	typedef TSMRExport inherited;
	
private:
	double FactorX;
	double FactorY;
	System::Classes::TStrings* lst;
	
public:
	virtual void __fastcall StartExport();
	virtual void __fastcall EndExport();
	virtual void __fastcall NewPage(int APage, int ABar);
	virtual void __fastcall ExportEMFRecord(HDC DC, Winapi::Windows::PHandleTable HandleTable, Winapi::Windows::PEnhMetaRecord EMFRecord, int nObj, void * OptData);
	virtual void __fastcall SaveToFile(System::UnicodeString FileName);
public:
	/* TSMRExport.Create */ inline __fastcall virtual TSMRExportToText(System::Classes::TComponent* AOwner) : TSMRExport(AOwner) { }
	/* TSMRExport.Destroy */ inline __fastcall virtual ~TSMRExportToText() { }
	
};


class PASCALIMPLEMENTATION TSMRExportToEMF : public TSMRExport
{
	typedef TSMRExport inherited;
	
private:
	Vcl::Graphics::TMetafileCanvas* dcCanvas;
	
protected:
	bool NeedSaveMetafile;
	Vcl::Graphics::TMetafile* Metafile;
	
public:
	__fastcall virtual TSMRExportToEMF(System::Classes::TComponent* AOwner);
	virtual void __fastcall StartExport();
	virtual void __fastcall EndExport();
	virtual void __fastcall NewPage(int APage, int ABar);
	virtual void __fastcall SaveToFile(System::UnicodeString FileName);
	virtual void __fastcall PageProcessed(Vcl::Graphics::TMetafile* OriginalMetafile);
public:
	/* TSMRExport.Destroy */ inline __fastcall virtual ~TSMRExportToEMF() { }
	
};


class PASCALIMPLEMENTATION TSMRExportToWMF : public TSMRExportToEMF
{
	typedef TSMRExportToEMF inherited;
	
public:
	virtual void __fastcall NewPage(int APage, int ABar);
public:
	/* TSMRExportToEMF.Create */ inline __fastcall virtual TSMRExportToWMF(System::Classes::TComponent* AOwner) : TSMRExportToEMF(AOwner) { }
	
public:
	/* TSMRExport.Destroy */ inline __fastcall virtual ~TSMRExportToWMF() { }
	
};


class PASCALIMPLEMENTATION TSMRExportToBMP : public TSMRExportToEMF
{
	typedef TSMRExportToEMF inherited;
	
private:
	Vcl::Graphics::TBitmapHandleType FHandleType;
	bool FMonochrome;
	Vcl::Graphics::TPixelFormat FPixelFormat;
	bool FTransparent;
	System::Uitypes::TColor FTransparentColor;
	Vcl::Graphics::TTransparentMode FTransparentMode;
	
protected:
	bool NeedSaveBitmap;
	Vcl::Graphics::TBitmap* BitmapCanvas;
	
public:
	__fastcall virtual TSMRExportToBMP(System::Classes::TComponent* AOwner);
	virtual void __fastcall StartExport();
	virtual void __fastcall EndExport();
	virtual void __fastcall SaveToFile(System::UnicodeString FileName);
	virtual void __fastcall PageProcessed(Vcl::Graphics::TMetafile* OriginalMetafile);
	
__published:
	__property Vcl::Graphics::TBitmapHandleType HandleType = {read=FHandleType, write=FHandleType, nodefault};
	__property bool Monochrome = {read=FMonochrome, write=FMonochrome, nodefault};
	__property Vcl::Graphics::TPixelFormat PixelFormat = {read=FPixelFormat, write=FPixelFormat, nodefault};
	__property bool Transparent = {read=FTransparent, write=FTransparent, nodefault};
	__property System::Uitypes::TColor TransparentColor = {read=FTransparentColor, write=FTransparentColor, nodefault};
	__property Vcl::Graphics::TTransparentMode TransparentMode = {read=FTransparentMode, write=FTransparentMode, nodefault};
public:
	/* TSMRExport.Destroy */ inline __fastcall virtual ~TSMRExportToBMP() { }
	
};


class PASCALIMPLEMENTATION TSMRExportToTIFF : public TSMRExportToBMP
{
	typedef TSMRExportToBMP inherited;
	
public:
	__fastcall virtual TSMRExportToTIFF(System::Classes::TComponent* AOwner);
	virtual void __fastcall SaveToFile(System::UnicodeString FileName);
public:
	/* TSMRExport.Destroy */ inline __fastcall virtual ~TSMRExportToTIFF() { }
	
};


enum DECLSPEC_DENUM TSMRMFERecordKind : unsigned char { rkText, rkLine, rkRectangle, rkEllipse, rkPicture };

typedef System::Set<TSMRMFERecordKind, TSMRMFERecordKind::rkText, TSMRMFERecordKind::rkPicture> TSMRMFERecordKinds;

class PASCALIMPLEMENTATION TSMRExportAttributes : public TSMRExport
{
	typedef TSMRExport inherited;
	
private:
	int FColCount;
	int FRowCount;
	TSMRMFERecordKinds FRecordKinds;
	
protected:
	Vcl::Graphics::TFont* FFont;
	System::Classes::TAlignment FAlignment;
	bool FTransparent;
	System::Uitypes::TColor FBackColor;
	Winapi::Windows::TPoint prevPoint;
	System::Classes::TList* SMRERecords;
	System::Classes::TList* lstColumns;
	void __fastcall WriteStringToStream(System::Classes::TStream* ToStream, const System::UnicodeString s);
	
public:
	__fastcall virtual TSMRExportAttributes(System::Classes::TComponent* AOwner);
	virtual void __fastcall StartExport();
	virtual void __fastcall EndExport();
	virtual void __fastcall SaveToFile(System::UnicodeString FileName);
	virtual void __fastcall ExportEMFRecord(HDC DC, Winapi::Windows::PHandleTable HandleTable, Winapi::Windows::PEnhMetaRecord EMFRecord, int nObj, void * OptData);
	__property int ColCount = {read=FColCount, nodefault};
	__property int RowCount = {read=FRowCount, nodefault};
	__property TSMRMFERecordKinds RecordKinds = {read=FRecordKinds, write=FRecordKinds, default=1};
public:
	/* TSMRExport.Destroy */ inline __fastcall virtual ~TSMRExportAttributes() { }
	
};


class PASCALIMPLEMENTATION TSMRExportToCSV : public TSMRExportAttributes
{
	typedef TSMRExportAttributes inherited;
	
public:
	virtual void __fastcall SaveToFile(System::UnicodeString FileName);
public:
	/* TSMRExportAttributes.Create */ inline __fastcall virtual TSMRExportToCSV(System::Classes::TComponent* AOwner) : TSMRExportAttributes(AOwner) { }
	
public:
	/* TSMRExport.Destroy */ inline __fastcall virtual ~TSMRExportToCSV() { }
	
};


enum DECLSPEC_DENUM TSpreadsheetCellType : unsigned char { ctBlank, ctInteger, ctDouble, ctString, ctDateTime, ctCurrency };

class PASCALIMPLEMENTATION TSMRMFERecord : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
public:
	TSMRMFERecordKind Kind;
	System::Classes::TAlignment Alignment;
	System::Uitypes::TColor BackColor;
	Vcl::Graphics::TFont* Font;
	System::LongInt Left;
	System::LongInt Top;
	System::LongInt Width;
	System::LongInt Height;
	System::UnicodeString Text;
	Vcl::Graphics::TBitmap* Bitmap;
	__fastcall virtual TSMRMFERecord();
	__fastcall virtual ~TSMRMFERecord();
};


class PASCALIMPLEMENTATION TSMRExportToSpreadsheet : public TSMRExportAttributes
{
	typedef TSMRExportAttributes inherited;
	
private:
	virtual void __fastcall WriteRecordHeader(int RecType, int Size);
	
protected:
	System::Classes::TFileStream* Stream;
	void __fastcall WriteString(const System::UnicodeString s);
	virtual void __fastcall WriteFileBegin();
	virtual void __fastcall WriteFileEnd();
	virtual void __fastcall WriteDimensions(System::Word intRowCount, System::Word intColCount);
	virtual void __fastcall WriteRowStart();
	virtual void __fastcall WriteRowEnd();
	virtual void __fastcall WriteData(TSpreadsheetCellType CellType, TSMRMFERecord* smrRec, int ARow, int ACol, System::ShortString &AString, System::Classes::TAlignment al, System::Uitypes::TColor color);
	
public:
	virtual void __fastcall SaveToFile(System::UnicodeString FileName);
public:
	/* TSMRExportAttributes.Create */ inline __fastcall virtual TSMRExportToSpreadsheet(System::Classes::TComponent* AOwner) : TSMRExportAttributes(AOwner) { }
	
public:
	/* TSMRExport.Destroy */ inline __fastcall virtual ~TSMRExportToSpreadsheet() { }
	
};


class PASCALIMPLEMENTATION TSMRExportToHTML : public TSMRExportToSpreadsheet
{
	typedef TSMRExportToSpreadsheet inherited;
	
private:
	System::Uitypes::TColor BodyBackColor;
	
protected:
	System::UnicodeString __fastcall GetHTMLColor(System::Uitypes::TColor cl, bool IsBackColor);
	System::UnicodeString __fastcall GetHTMLFontSize(int Size);
	System::UnicodeString __fastcall GetHTMLTextWithFont(System::UnicodeString s, Vcl::Graphics::TFont* fn);
	virtual void __fastcall WriteFileBegin();
	virtual void __fastcall WriteFileEnd();
	virtual void __fastcall WriteRowStart();
	virtual void __fastcall WriteRowEnd();
	virtual void __fastcall WriteData(TSpreadsheetCellType CellType, TSMRMFERecord* smrRec, int ARow, int ACol, System::ShortString &AString, System::Classes::TAlignment al, System::Uitypes::TColor color);
	
public:
	__fastcall virtual TSMRExportToHTML(System::Classes::TComponent* AOwner);
public:
	/* TSMRExport.Destroy */ inline __fastcall virtual ~TSMRExportToHTML() { }
	
};


class PASCALIMPLEMENTATION TSMRExportToXML : public TSMRExportToSpreadsheet
{
	typedef TSMRExportToSpreadsheet inherited;
	
protected:
	virtual void __fastcall WriteFileBegin();
	virtual void __fastcall WriteFileEnd();
	virtual void __fastcall WriteRowStart();
	virtual void __fastcall WriteRowEnd();
	virtual void __fastcall WriteData(TSpreadsheetCellType CellType, TSMRMFERecord* smrRec, int ARow, int ACol, System::ShortString &AString, System::Classes::TAlignment al, System::Uitypes::TColor color);
public:
	/* TSMRExportAttributes.Create */ inline __fastcall virtual TSMRExportToXML(System::Classes::TComponent* AOwner) : TSMRExportToSpreadsheet(AOwner) { }
	
public:
	/* TSMRExport.Destroy */ inline __fastcall virtual ~TSMRExportToXML() { }
	
};


class PASCALIMPLEMENTATION TSMRExportToExcel : public TSMRExportToSpreadsheet
{
	typedef TSMRExportToSpreadsheet inherited;
	
protected:
	virtual void __fastcall WriteFileBegin();
	virtual void __fastcall WriteFileEnd();
	virtual void __fastcall WriteDimensions(System::Word intRowCount, System::Word intColCount);
	virtual void __fastcall WriteData(TSpreadsheetCellType CellType, TSMRMFERecord* smrRec, int ARow, int ACol, System::ShortString &AString, System::Classes::TAlignment al, System::Uitypes::TColor color);
public:
	/* TSMRExportAttributes.Create */ inline __fastcall virtual TSMRExportToExcel(System::Classes::TComponent* AOwner) : TSMRExportToSpreadsheet(AOwner) { }
	
public:
	/* TSMRExport.Destroy */ inline __fastcall virtual ~TSMRExportToExcel() { }
	
};


class PASCALIMPLEMENTATION TSMRExportToLotus : public TSMRExportToSpreadsheet
{
	typedef TSMRExportToSpreadsheet inherited;
	
protected:
	virtual void __fastcall WriteFileBegin();
	virtual void __fastcall WriteFileEnd();
	virtual void __fastcall WriteDimensions(System::Word intRowCount, System::Word intColCount);
	virtual void __fastcall WriteData(TSpreadsheetCellType CellType, TSMRMFERecord* smrRec, int ARow, int ACol, System::ShortString &AString, System::Classes::TAlignment al, System::Uitypes::TColor color);
public:
	/* TSMRExportAttributes.Create */ inline __fastcall virtual TSMRExportToLotus(System::Classes::TComponent* AOwner) : TSMRExportToSpreadsheet(AOwner) { }
	
public:
	/* TSMRExport.Destroy */ inline __fastcall virtual ~TSMRExportToLotus() { }
	
};


class PASCALIMPLEMENTATION TSMRExportToQuattroPro : public TSMRExportToSpreadsheet
{
	typedef TSMRExportToSpreadsheet inherited;
	
protected:
	virtual void __fastcall WriteFileBegin();
	virtual void __fastcall WriteFileEnd();
	virtual void __fastcall WriteDimensions(System::Word intRowCount, System::Word intColCount);
	virtual void __fastcall WriteData(TSpreadsheetCellType CellType, TSMRMFERecord* smrRec, int ARow, int ACol, System::ShortString &AString, System::Classes::TAlignment al, System::Uitypes::TColor color);
public:
	/* TSMRExportAttributes.Create */ inline __fastcall virtual TSMRExportToQuattroPro(System::Classes::TComponent* AOwner) : TSMRExportToSpreadsheet(AOwner) { }
	
public:
	/* TSMRExport.Destroy */ inline __fastcall virtual ~TSMRExportToQuattroPro() { }
	
};


class PASCALIMPLEMENTATION TSMRExportToRTF : public TSMRExportToSpreadsheet
{
	typedef TSMRExportToSpreadsheet inherited;
	
private:
	System::Classes::TFileStream* TempStream;
	System::Classes::TStrings* lstFonts;
	System::Classes::TStrings* lstColors;
	HIDESBASE void __fastcall WriteString(System::Classes::TStream* Stream, const System::UnicodeString s);
	System::UnicodeString __fastcall GetFromTable(System::Classes::TStrings* lstTable, int intShift, const System::UnicodeString Value);
	
protected:
	System::UnicodeString __fastcall GetAlignment(System::Classes::TAlignment alignment);
	System::UnicodeString __fastcall GetFontStyle(System::Uitypes::TFontStyles fs);
	System::UnicodeString __fastcall WriteBitmap(Vcl::Graphics::TBitmap* bmp);
	void __fastcall LineToRTF();
	System::UnicodeString __fastcall DateTimeToRTF(System::TDateTime Value);
	virtual void __fastcall WriteDimensions(System::Word intRowCount, System::Word intColCount);
	virtual void __fastcall WriteFileBegin();
	virtual void __fastcall WriteFileEnd();
	virtual void __fastcall WriteRowStart();
	virtual void __fastcall WriteRowEnd();
	virtual void __fastcall WriteData(TSpreadsheetCellType CellType, TSMRMFERecord* smrRec, int ARow, int ACol, System::ShortString &AString, System::Classes::TAlignment al, System::Uitypes::TColor color);
	
public:
	__fastcall virtual TSMRExportToRTF(System::Classes::TComponent* AOwner);
	virtual void __fastcall SaveToFile(System::UnicodeString FileName);
public:
	/* TSMRExport.Destroy */ inline __fastcall virtual ~TSMRExportToRTF() { }
	
};


class PASCALIMPLEMENTATION TSMRPDFFont : public System::TObject
{
	typedef System::TObject inherited;
	
public:
	System::UnicodeString RefIndex;
	System::UnicodeString BaseFont;
	System::UnicodeString FontName;
	System::Uitypes::TFontName Name;
	System::Uitypes::TFontCharset CharSet;
	System::Uitypes::TFontStyles Style;
	bool IsTrueType;
	bool IsEmbeddable;
	int Flags;
	void __fastcall FontParameters(Vcl::Graphics::TFont* Font);
	System::UnicodeString __fastcall GetFontName();
	bool __fastcall IsStandardFont();
	System::UnicodeString __fastcall EncodingString();
public:
	/* TObject.Create */ inline __fastcall TSMRPDFFont() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TSMRPDFFont() { }
	
};


class PASCALIMPLEMENTATION TSMRPDFFonts : public System::Classes::TList
{
	typedef System::Classes::TList inherited;
	
private:
	System::UnicodeString __fastcall FontFamily(Vcl::Graphics::TFont* Font, System::Uitypes::TFontCharset Charset);
	System::Uitypes::TFontCharset __fastcall GetFontCharset(System::Uitypes::TFontCharset AValue);
	int __fastcall GetItemByFont(const System::UnicodeString BaseFont, System::Uitypes::TFontCharset Charset);
	int __fastcall FontFromTable(TSMRExportToPDF* PDFEngine, Vcl::Graphics::TFont* Font);
	void __fastcall WriteFontDifferences(TSMRExportToPDF* PDFEngine, TSMRPDFFont* fnt);
	
public:
	TSMRPDFFont* __fastcall GetFont(int Index);
	virtual void __fastcall Clear();
	void __fastcall WriteFonts(TSMRExportToPDF* PDFEngine);
public:
	/* TList.Destroy */ inline __fastcall virtual ~TSMRPDFFonts() { }
	
public:
	/* TObject.Create */ inline __fastcall TSMRPDFFonts() : System::Classes::TList() { }
	
};


enum DECLSPEC_DENUM TSMRECompression : unsigned char { seASCIIHex, seASCII85, seLZW, seDCT, seFlate };

enum DECLSPEC_DENUM TSMRECompressionMethod : unsigned char { cmFastest, cmNormal, cmMaxCompress };

class PASCALIMPLEMENTATION TSMRExportToPDF : public TSMRExportAttributes
{
	typedef TSMRExportAttributes inherited;
	
private:
	TSMRECompression FCompression;
	TSMRECompressionMethod FCompressionMethod;
	int MaxKids;
	int ObjNo;
	System::Classes::TStringList* CrossRef;
	TSMRPDFFonts* tblFont;
	System::Classes::TStrings* tblImage;
	System::Classes::TStrings* lstPages;
	int intTotalPages;
	int StreamSize;
	int FilePos;
	System::UnicodeString StreamObj;
	System::UnicodeString ProcObj;
	System::UnicodeString BodyObj;
	System::UnicodeString ResObj;
	bool IsMemStream;
	
protected:
	System::Classes::TFileStream* Stream;
	System::Classes::TMemoryStream* MemStream;
	void __fastcall WriteString(System::UnicodeString s);
	void __fastcall WriteLine(int Left, int Top, int Width, int Height, System::Uitypes::TColor ForeColor, System::Uitypes::TColor BackColor);
	void __fastcall AddRef(System::UnicodeString Obj);
	System::UnicodeString __fastcall GetNextRefIndex();
	System::UnicodeString __fastcall FontFamily(Vcl::Graphics::TFont* Font);
	void __fastcall WriteCrossRef();
	void __fastcall WriteBitmap(int Index, System::UnicodeString ImageRefIndex, Vcl::Graphics::TBitmap* bmp);
	void __fastcall StartPage();
	void __fastcall EndPage();
	void __fastcall StartJob();
	void __fastcall EndJob();
	
public:
	__fastcall virtual TSMRExportToPDF(System::Classes::TComponent* AOwner);
	virtual void __fastcall SaveToFile(System::UnicodeString FileName);
	
__published:
	__property TSMRECompression Compression = {read=FCompression, write=FCompression, default=0};
	__property TSMRECompressionMethod CompressionMethod = {read=FCompressionMethod, write=FCompressionMethod, default=1};
public:
	/* TSMRExport.Destroy */ inline __fastcall virtual ~TSMRExportToPDF() { }
	
};


typedef TSMRRegisterExport *PSMRRegisterExport;

struct DECLSPEC_DRECORD TSMRRegisterExport
{
public:
	System::UnicodeString ExportClassName;
	System::UnicodeString FileExtension;
	int DescriptionIndex;
	System::UnicodeString Description;
	int FilterNameIndex;
	System::UnicodeString FilterName;
	System::LongInt hInstance;
	Winapi::Windows::THandle hIcon;
};


//-- var, const, procedure ---------------------------------------------------
extern DELPHI_PACKAGE System::Classes::TList* SMRExports;
extern DELPHI_PACKAGE int SMR_EQUAL_X;
extern DELPHI_PACKAGE int SMR_EQUAL_Y;
extern DELPHI_PACKAGE System::LongBool __stdcall SMREnumEMFRecordsProc(HDC DC, Winapi::Windows::PHandleTable HandleTable, Winapi::Windows::PEnhMetaRecord EMFRecord, int nObj, void * OptData);
extern DELPHI_PACKAGE void __fastcall RegisterSMRExport(TSMRExportClass ASMRExportClass, System::UnicodeString AFileExtension, int ADescriptionIndex, System::UnicodeString ADescription, int AFilterNameIndex, System::UnicodeString AFilterName, System::LongInt AHInstance);
extern DELPHI_PACKAGE void __fastcall UnRegisterSMRExport(TSMRExportClass ASMRExportClass);
}	/* namespace Smrexprt */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMREXPRT)
using namespace Smrexprt;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMRExprtHPP
