﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMRBase.pas' rev: 37.00 (Windows)

#ifndef SMRBaseHPP
#define SMRBaseHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <Winapi.Messages.hpp>
#include <System.SysUtils.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <Vcl.Controls.hpp>
#include <Vcl.Forms.hpp>
#include <Vcl.Dialogs.hpp>
#include <Data.DB.hpp>
#include <Vcl.ComCtrls.hpp>
#include <System.UITypes.hpp>
#include <SMRCnst.hpp>
#include <PrintSM.hpp>
#include <SMPWhen.hpp>
#include <SMRTypes.hpp>
#include <SMRPars.hpp>
#include <SMRDMan.hpp>
#include <System.Types.hpp>
#include <Vcl.Menus.hpp>
#include <SMPrntr.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smrbase
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMRControl;
class DELPHICLASS TSMRLabel;
class DELPHICLASS TSMRExpression;
class DELPHICLASS TSMRSysData;
class DELPHICLASS TSMRShape;
class DELPHICLASS TSMRLine;
class DELPHICLASS TSMRRectangle;
class DELPHICLASS TSMREllipse;
class DELPHICLASS TSMRImage;
class DELPHICLASS TSMRichText;
class DELPHICLASS TSMRBand;
class DELPHICLASS TSMReport;
struct TSMRRegisterControl;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TSMRControlResize : unsigned char { scrLeftTop, scrTop, scrRightTop, scrLeft, scrRight, scrLeftBottom, scrBottom, scrRightBottom, scrNone };

enum DECLSPEC_DENUM TSMRControlState : unsigned char { scsNothing, scsResize, scsMove };

enum DECLSPEC_DENUM TSMRObjectPosition : unsigned char { opDesigned, opTopBand, opBottomBand, opCenterBand };

_DECLARE_METACLASS(System::TMetaClass, TSMRControlClass);

class PASCALIMPLEMENTATION TSMRControl : public Vcl::Controls::TGraphicControl
{
	typedef Vcl::Controls::TGraphicControl inherited;
	
private:
	System::Variant FPrevValue;
	System::Variant FCurValue;
	bool FCanBePrinted;
	Smpwhen::TSMPrintWhen* FSMPrintWhen;
	Smrtypes::TSMRHighLights* FHighLights;
	System::UnicodeString FDisplayName;
	bool FSelected;
	System::Classes::TAlignment FAlignment;
	Printsm::TSMRFrame* FFrame;
	Vcl::Graphics::TBrushStyle FBrushStyle;
	System::Classes::TStrings* FComments;
	TSMRObjectPosition FObjectPosition;
	System::Uitypes::TColor FBackColor;
	TSMRBand* FParentBand;
	TSMRControlState FSMRControlState;
	void __fastcall SetSMRControlState(TSMRControlState Value);
	System::Variant __fastcall GetPrevValue();
	System::Variant __fastcall GetCurValue();
	void __fastcall SetPrevValue(const System::Variant &Value);
	void __fastcall SetCurValue(const System::Variant &Value);
	bool __fastcall GetTransparent();
	void __fastcall SetTransparent(bool Value);
	void __fastcall SetSelected(bool Value);
	void __fastcall SetFrame(Printsm::TSMRFrame* Value);
	void __fastcall SetDisplayName(System::UnicodeString Value);
	void __fastcall SetComments(System::Classes::TStrings* Value);
	void __fastcall SetSMPrintWhen(Smpwhen::TSMPrintWhen* Value);
	Smrtypes::TSMRHighLights* __fastcall GetHighLights();
	void __fastcall SetHighLights(Smrtypes::TSMRHighLights* Value);
	void __fastcall DrawDefault(Vcl::Graphics::TCanvas* ACanvas, const Winapi::Windows::TRect &ARect);
	void __fastcall DrawPoint(Vcl::Graphics::TCanvas* ACanvas, int X, int Y);
	void __fastcall DrawSelection(Vcl::Graphics::TCanvas* ACanvas, const Winapi::Windows::TRect &ARect);
	int __fastcall DrawWrapText(Vcl::Graphics::TCanvas* ACanvas, System::UnicodeString Text, const Winapi::Windows::TRect &ARect, System::Word Flags, int AAngle);
	int __fastcall GetControlIndex();
	TSMRBand* __fastcall GetParentBand();
	void __fastcall SetParentBand(TSMRBand* AValue);
	
protected:
	virtual void __fastcall SetName(const System::Classes::TComponentName NewName);
	virtual void __fastcall Paint();
	virtual void __fastcall ReadState(System::Classes::TReader* Reader);
	virtual void __fastcall SetAlignment(System::Classes::TAlignment Value);
	virtual void __fastcall UpdateCurValue();
	virtual bool __fastcall ValueChanged();
	Data::Db::TDataSet* __fastcall GetDatasetByName(System::UnicodeString AExpression);
	
public:
	TSMReport* FSMReport;
	int StartMouseDownX;
	int StartMouseDownY;
	TSMRControlResize SMRControlResize;
	__fastcall virtual TSMRControl(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMRControl();
	virtual int __fastcall Draw(Vcl::Graphics::TCanvas* ACanvas, Winapi::Windows::TRect &ARect, int intBandHeight, System::Word Flags);
	void __fastcall MoveToBand(TSMRBand* bandTarget);
	__property bool Selected = {read=FSelected, write=SetSelected, nodefault};
	__property TSMRControlState SMRControlState = {read=FSMRControlState, write=SetSMRControlState, nodefault};
	__property System::Variant PrevValue = {read=GetPrevValue, write=SetPrevValue};
	__property System::Variant CurValue = {read=GetCurValue, write=SetCurValue};
	__property bool CanBePrinted = {read=FCanBePrinted, nodefault};
	__property int Index = {read=GetControlIndex, nodefault};
	__property TSMRBand* ParentBand = {read=GetParentBand, write=SetParentBand};
	
__published:
	__property System::UnicodeString DisplayName = {read=FDisplayName, write=SetDisplayName};
	__property Printsm::TSMRFrame* Frame = {read=FFrame, write=SetFrame};
	__property System::Classes::TAlignment Alignment = {read=FAlignment, write=SetAlignment, default=0};
	__property bool Transparent = {read=GetTransparent, write=SetTransparent, default=1};
	__property Vcl::Graphics::TBrushStyle BrushStyle = {read=FBrushStyle, write=FBrushStyle, default=0};
	__property System::Classes::TStrings* Comments = {read=FComments, write=SetComments};
	__property Smrtypes::TSMRHighLights* HighLights = {read=GetHighLights, write=SetHighLights};
	__property TSMRObjectPosition ObjectPosition = {read=FObjectPosition, write=FObjectPosition, default=0};
	__property System::Uitypes::TColor BackColor = {read=FBackColor, write=FBackColor, default=16777215};
	__property Smpwhen::TSMPrintWhen* SMPrintWhen = {read=FSMPrintWhen, write=SetSMPrintWhen};
	__property Height = {default=20};
	__property Width = {default=50};
	__property Left = {default=10};
	__property Top = {default=40};
	__property Font;
	__property Hint = {default=0};
	__property PopupMenu;
	__property OnClick;
	__property OnDblClick;
	__property OnDragDrop;
	__property OnDragOver;
	__property OnEndDrag;
	__property OnMouseDown;
	__property OnMouseMove;
	__property OnMouseUp;
	__property OnStartDrag;
};


class PASCALIMPLEMENTATION TSMRLabel : public TSMRControl
{
	typedef TSMRControl inherited;
	
private:
	bool FWordWrap;
	int FAngle;
	bool FStretch;
	void __fastcall SetAngle(int Value);
	int __fastcall DoDrawText(Vcl::Graphics::TCanvas* ACanvas, const Winapi::Windows::TRect &ARect, System::Word Flags, System::UnicodeString Text);
	
protected:
	virtual System::UnicodeString __fastcall GetValueForShow(Vcl::Graphics::TCanvas* ACanvas, const System::Variant &Value);
	virtual void __fastcall UpdateCurValue();
	
public:
	__fastcall virtual TSMRLabel(System::Classes::TComponent* AOwner);
	virtual int __fastcall Draw(Vcl::Graphics::TCanvas* ACanvas, Winapi::Windows::TRect &ARect, int intBandHeight, System::Word Flags);
	
__published:
	__property int Angle = {read=FAngle, write=SetAngle, default=0};
	__property bool WordWrap = {read=FWordWrap, write=FWordWrap, default=1};
	__property bool Stretch = {read=FStretch, write=FStretch, default=1};
public:
	/* TSMRControl.Destroy */ inline __fastcall virtual ~TSMRLabel() { }
	
};


class PASCALIMPLEMENTATION TSMRExpression : public TSMRLabel
{
	typedef TSMRLabel inherited;
	
private:
	System::UnicodeString FExpression;
	System::UnicodeString FFormat;
	Smrtypes::TSMRCalculation* FCalculation;
	void __fastcall SetCalculation(Smrtypes::TSMRCalculation* Value);
	void __fastcall SetExpression(System::UnicodeString Value);
	
protected:
	virtual System::UnicodeString __fastcall GetValueForShow(Vcl::Graphics::TCanvas* ACanvas, const System::Variant &Value);
	virtual void __fastcall UpdateCurValue();
	
public:
	__fastcall virtual TSMRExpression(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMRExpression();
	
__published:
	__property System::UnicodeString Expression = {read=FExpression, write=SetExpression};
	__property System::UnicodeString Format = {read=FFormat, write=FFormat};
	__property Smrtypes::TSMRCalculation* Calculation = {read=FCalculation, write=SetCalculation};
};


class PASCALIMPLEMENTATION TSMRSysData : public TSMRLabel
{
	typedef TSMRLabel inherited;
	
private:
	Smrcnst::TSMRSysDataType FSysData;
	System::UnicodeString FFormat;
	void __fastcall SetSysData(Smrcnst::TSMRSysDataType Value);
	
protected:
	virtual System::UnicodeString __fastcall GetValueForShow(Vcl::Graphics::TCanvas* ACanvas, const System::Variant &Value);
	virtual void __fastcall UpdateCurValue();
	
public:
	__fastcall virtual TSMRSysData(System::Classes::TComponent* AOwner);
	
__published:
	__property Smrcnst::TSMRSysDataType SysData = {read=FSysData, write=SetSysData, default=2};
	__property System::UnicodeString Format = {read=FFormat, write=FFormat};
public:
	/* TSMRControl.Destroy */ inline __fastcall virtual ~TSMRSysData() { }
	
};


enum DECLSPEC_DENUM TLineStyle : unsigned char { lsSingle, lsDouble };

enum DECLSPEC_DENUM TShapeStretch : unsigned char { ssNoStretch, ssTallest, ssHeight };

enum DECLSPEC_DENUM TShapeType : unsigned char { stLine, stRectangle, stEllipse };

enum DECLSPEC_DENUM TLineType : unsigned char { ltTop, ltBottom, ltLeft, ltRight, ltLeftDiagonal, ltRightDiagonal, ltHCenter, ltVCenter };

enum DECLSPEC_DENUM TRectangleType : unsigned char { rtRectangle, rtRoundRect, rtSquare, rtRoundSquare };

enum DECLSPEC_DENUM TEllipseType : unsigned char { etEllipse, etCircle };

class PASCALIMPLEMENTATION TSMRShape : public TSMRControl
{
	typedef TSMRControl inherited;
	
private:
	TShapeStretch FStretch;
	TLineType FLineType;
	TRectangleType FRectangleType;
	TEllipseType FEllipseType;
	TLineStyle FLineStyle;
	void __fastcall DrawLine(Vcl::Graphics::TCanvas* ACanvas, const Winapi::Windows::TRect &BRect);
	
public:
	TShapeType ShapeType;
	__fastcall virtual TSMRShape(System::Classes::TComponent* AOwner);
	virtual int __fastcall Draw(Vcl::Graphics::TCanvas* ACanvas, Winapi::Windows::TRect &ARect, int intBandHeight, System::Word Flags);
	__property TLineType LineType = {read=FLineType, write=FLineType, nodefault};
	__property TRectangleType RectangleType = {read=FRectangleType, write=FRectangleType, nodefault};
	__property TEllipseType EllipseType = {read=FEllipseType, write=FEllipseType, nodefault};
	
__published:
	__property TShapeStretch Stretch = {read=FStretch, write=FStretch, nodefault};
	__property TLineStyle LineStyle = {read=FLineStyle, write=FLineStyle, default=1};
public:
	/* TSMRControl.Destroy */ inline __fastcall virtual ~TSMRShape() { }
	
};


class PASCALIMPLEMENTATION TSMRLine : public TSMRShape
{
	typedef TSMRShape inherited;
	
public:
	__fastcall virtual TSMRLine(System::Classes::TComponent* AOwner);
	
__published:
	__property LineType;
public:
	/* TSMRControl.Destroy */ inline __fastcall virtual ~TSMRLine() { }
	
};


class PASCALIMPLEMENTATION TSMRRectangle : public TSMRShape
{
	typedef TSMRShape inherited;
	
public:
	__fastcall virtual TSMRRectangle(System::Classes::TComponent* AOwner);
	
__published:
	__property RectangleType;
public:
	/* TSMRControl.Destroy */ inline __fastcall virtual ~TSMRRectangle() { }
	
};


class PASCALIMPLEMENTATION TSMREllipse : public TSMRShape
{
	typedef TSMRShape inherited;
	
public:
	__fastcall virtual TSMREllipse(System::Classes::TComponent* AOwner);
	
__published:
	__property EllipseType;
public:
	/* TSMRControl.Destroy */ inline __fastcall virtual ~TSMREllipse() { }
	
};


enum DECLSPEC_DENUM TSMRImageKind : unsigned char { ikFile, ikField, ikPicture };

class PASCALIMPLEMENTATION TSMRImage : public TSMRControl
{
	typedef TSMRControl inherited;
	
private:
	System::UnicodeString FExpression;
	Vcl::Graphics::TPicture* FPicture;
	System::UnicodeString FFileName;
	TSMRImageKind FImageKind;
	bool FStretch;
	bool FAspectRatio;
	bool FCenter;
	void __fastcall SetPicture(Vcl::Graphics::TPicture* Value);
	
public:
	__fastcall virtual TSMRImage(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMRImage();
	virtual int __fastcall Draw(Vcl::Graphics::TCanvas* ACanvas, Winapi::Windows::TRect &ARect, int intBandHeight, System::Word Flags);
	
__published:
	__property TSMRImageKind ImageKind = {read=FImageKind, write=FImageKind, default=0};
	__property System::UnicodeString FileName = {read=FFileName, write=FFileName};
	__property System::UnicodeString Expression = {read=FExpression, write=FExpression};
	__property Vcl::Graphics::TPicture* Picture = {read=FPicture, write=SetPicture};
	__property bool Stretch = {read=FStretch, write=FStretch, nodefault};
	__property bool Center = {read=FCenter, write=FCenter, nodefault};
	__property bool AspectRatio = {read=FAspectRatio, write=FAspectRatio, nodefault};
};


class PASCALIMPLEMENTATION TSMRichText : public TSMRControl
{
	typedef TSMRControl inherited;
	
private:
	System::UnicodeString FExpression;
	Vcl::Comctrls::TRichEdit* FRichEdit;
	System::UnicodeString FFileName;
	bool FStretch;
	
public:
	__fastcall virtual TSMRichText(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMRichText();
	virtual int __fastcall Draw(Vcl::Graphics::TCanvas* ACanvas, Winapi::Windows::TRect &ARect, int intBandHeight, System::Word Flags);
	
__published:
	__property System::UnicodeString FileName = {read=FFileName, write=FFileName};
	__property bool Stretch = {read=FStretch, write=FStretch, nodefault};
	__property System::UnicodeString Expression = {read=FExpression, write=FExpression};
};


typedef void __fastcall (__closure *TDrawGridEvent)(System::TObject* Sender, const Winapi::Windows::TRect &R);

enum DECLSPEC_DENUM TBandType : unsigned char { btNone, btReportTitle, btPageHeader, btColumnHeader, btGroupHeader, btDetail, btGroupFooter, btColumnFooter, btPageFooter, btReportSummary, btSubDetail };

class PASCALIMPLEMENTATION TSMRBand : public TSMRControl
{
	typedef TSMRControl inherited;
	
private:
	TDrawGridEvent FOnDrawGrid;
	int FLinkedBand;
	TBandType FBandType;
	bool FStretch;
	bool FNewPage;
	bool FReprintHeader;
	double FLessThan;
	bool FNewPageIfNotFit;
	System::UnicodeString FExpression;
	int FLineNo;
	System::UnicodeString FOutlineExpression;
	Data::Db::TDataSet* FDataset;
	Data::Db::TDataSet* __fastcall GetDataset();
	void __fastcall SetDataset(Data::Db::TDataSet* Value);
	bool __fastcall GetIsGroup();
	int __fastcall GetBandIndex();
	void __fastcall SetBandType(TBandType Value);
	
protected:
	virtual void __fastcall Paint();
	int __fastcall PrintBand(int intShift, int intBottom, System::Word Flags);
	int __fastcall GetFullGroupHeight(int intShift, int intBottom);
	void __fastcall UpdateGroupValue();
	virtual bool __fastcall ValueChanged();
	int __fastcall GetLinkedFooterIndex();
	DYNAMIC void __fastcall GetChildren(System::Classes::TGetChildProc Proc, System::Classes::TComponent* Root);
	virtual void __fastcall ReadState(System::Classes::TReader* Reader);
	DYNAMIC System::Classes::TComponent* __fastcall GetChildParent();
	DYNAMIC System::Classes::TComponent* __fastcall GetChildOwner();
	
public:
	System::Classes::TList* Objects;
	__fastcall virtual TSMRBand(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMRBand();
	int __fastcall AddElement(TSMRControlClass cntrlClass);
	int __fastcall GetElement(TSMRControl* smrControl);
	TSMRControlClass __fastcall GetClassByName(System::UnicodeString strClassName);
	void __fastcall DeleteAllElements();
	void __fastcall ChangeOrder(bool BringToFront);
	System::UnicodeString __fastcall GetBandName();
	int __fastcall GetColumnWidth();
	__property TDrawGridEvent OnDrawGrid = {read=FOnDrawGrid, write=FOnDrawGrid};
	__property int Index = {read=GetBandIndex, nodefault};
	
__published:
	__property Data::Db::TDataSet* Dataset = {read=GetDataset, write=SetDataset};
	__property bool IsGroup = {read=GetIsGroup, nodefault};
	__property int LinkedBand = {read=FLinkedBand, write=FLinkedBand, nodefault};
	__property TBandType BandType = {read=FBandType, write=SetBandType, default=0};
	__property bool Stretch = {read=FStretch, write=FStretch, default=0};
	__property bool NewPage = {read=FNewPage, write=FNewPage, default=0};
	__property bool ReprintHeader = {read=FReprintHeader, write=FReprintHeader, default=0};
	__property double LessThan = {read=FLessThan, write=FLessThan};
	__property bool NewPageIfNotFit = {read=FNewPageIfNotFit, write=FNewPageIfNotFit, default=0};
	__property System::UnicodeString Expression = {read=FExpression, write=FExpression};
	__property int LineNo = {read=FLineNo, nodefault};
	__property Height = {default=100};
	__property System::UnicodeString OutlineExpression = {read=FOutlineExpression, write=FOutlineExpression};
};


enum DECLSPEC_DENUM TSMReportState : unsigned char { rsNone, rsDesign, rsPrepare, rsPrint };

typedef void __fastcall (__closure *TColumnEvent)(System::TObject* Sender, int Column);

typedef void __fastcall (__closure *TGenerateBeforeEvent)(System::TObject* Sender, TSMRControl* cntrl, bool IsPreCalc);

typedef void __fastcall (__closure *TGenerateAfterEvent)(System::TObject* Sender, TSMRControl* cntrl, bool IsPreCalc, bool &Abort);

enum DECLSPEC_DENUM TUpdateValue : unsigned char { uvAllBand, uvWithoutGroupFooter, uvOnlyGroupFooter, uvOnlyCustomVariables };

enum DECLSPEC_DENUM TSMRSelectMode : unsigned char { smSelect, smUnSelect, smRevert, smBandUnSelect };

class PASCALIMPLEMENTATION TSMReport : public Printsm::TSMPrintComponent
{
	typedef Printsm::TSMPrintComponent inherited;
	
private:
	int intBarWidth;
	int intColumnLeft;
	int intColumnTop;
	int intColumnBottom;
	bool boolWasNewPage;
	System::UnicodeString FFileName;
	int FStartAt;
	int FCountBy;
	int FBarNumber;
	int FColumnSpace;
	int FColumnNumber;
	TColumnEvent FBeginColumn;
	TColumnEvent FEndColumn;
	TGenerateBeforeEvent FBeforeControlPrint;
	TGenerateAfterEvent FAfterControlPrint;
	TGenerateBeforeEvent FBeforeBandPrint;
	TGenerateAfterEvent FAfterBandPrint;
	Smrtypes::TSMRParameters* FParameters;
	Data::Db::TDataSet* FDataSet;
	Smrdman::TSMRDataManager* FDataManager;
	Data::Db::TDataSet* __fastcall GetDataSet();
	void __fastcall SetDataSet(Data::Db::TDataSet* AValue);
	void __fastcall SetDataManager(Smrdman::TSMRDataManager* Value);
	void __fastcall SetParameters(Smrtypes::TSMRParameters* Value);
	void __fastcall ResetPrintedValues(Smrtypes::TResetType RType, System::UnicodeString strGroupName);
	System::UnicodeString __fastcall GetFileName();
	
protected:
	bool InternalLoading;
	virtual void __fastcall SetName(const System::Classes::TComponentName NewName);
	virtual void __fastcall Notification(System::Classes::TComponent* AComponent, System::Classes::TOperation Operation);
	DYNAMIC void __fastcall GetChildren(System::Classes::TGetChildProc Proc, System::Classes::TComponent* Root);
	virtual void __fastcall ReadState(System::Classes::TReader* Reader);
	DYNAMIC System::Classes::TComponent* __fastcall GetChildParent();
	DYNAMIC System::Classes::TComponent* __fastcall GetChildOwner();
	System::UnicodeString __fastcall GetUniqueName(System::UnicodeString sName);
	void __fastcall UpdateCurValues(int intStartBand, int intEndBand, TUpdateValue UpdateValues, const System::UnicodeString AGroupChanged, const System::UnicodeString AVariableChanged);
	void __fastcall UpdateControlStates();
	virtual void __fastcall PrepareReport();
	virtual int __fastcall GetPageNoCountBy();
	virtual int __fastcall GetPageNoStartAt();
	virtual int __fastcall GetCurColumn();
	virtual int __fastcall GetColumnNumber();
	virtual void __fastcall SMRGetVariable(System::TObject* Sender, System::UnicodeString VariableName, bool &Accept, Data::Db::TFieldType &VariableType, System::Variant &Value);
	
public:
	TSMReportState ReportState;
	System::Classes::TList* Bands;
	int intCurColumn;
	__fastcall virtual TSMReport(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMReport();
	void __fastcall NewReport();
	bool __fastcall AskParameters();
	void __fastcall SaveReportToStream(System::Classes::TStream* AStream);
	void __fastcall SaveReport(System::UnicodeString AFileName);
	void __fastcall LoadReportFromStream(System::Classes::TStream* AStream);
	void __fastcall LoadReport(System::UnicodeString AFileName);
	void __fastcall BandReOrder();
	int __fastcall AppendBand(TSMRBand* band, bool boolAppend);
	int __fastcall AddBand(TBandType bt, bool boolAppend);
	void __fastcall DeleteBand(int i);
	void __fastcall DeleteAllBands();
	void __fastcall AddGroup(int &intGroupHeader, int &intGroupFooter, bool boolNewPage, bool boolReprintHeader, bool boolNewPageIfNotFit, double flLessThan, System::UnicodeString strExpression);
	void __fastcall DeleteGroup(System::UnicodeString strExpression);
	int __fastcall GetIndexBand(TBandType bt);
	TSMRBand* __fastcall GetBand(int i);
	int __fastcall GetBandLineNo(TBandType bt);
	TSMRControl* __fastcall GetFirstSelected();
	void __fastcall SelectElements(TSMRSelectMode SelectMode);
	void __fastcall AssignGroups(bool boolClear, System::Classes::TStrings* sl);
	Smrdman::TSMRDataManager* __fastcall GetDataManager();
	void __fastcall AssignDataSets(System::Classes::TStrings* sl);
	virtual void __fastcall NewPage(bool isNewBar);
	
__published:
	__property Data::Db::TDataSet* DataSet = {read=GetDataSet, write=SetDataSet};
	__property Smrdman::TSMRDataManager* DataManager = {read=FDataManager, write=SetDataManager};
	__property int BarNumber = {read=FBarNumber, write=FBarNumber, default=1};
	__property int ColumnSpace = {read=FColumnSpace, write=FColumnSpace, default=0};
	__property int ColumnNumber = {read=GetColumnNumber, write=FColumnNumber, default=1};
	__property System::UnicodeString FileName = {read=GetFileName, write=FFileName};
	__property int PageNoStartAt = {read=GetPageNoStartAt, write=FStartAt, default=0};
	__property int PageNoCountBy = {read=GetPageNoCountBy, write=FCountBy, default=1};
	__property Variables;
	__property Smrtypes::TSMRParameters* Parameters = {read=FParameters, write=SetParameters};
	__property TColumnEvent OnBeginColumn = {read=FBeginColumn, write=FBeginColumn};
	__property TColumnEvent OnEndColumn = {read=FEndColumn, write=FEndColumn};
	__property TGenerateBeforeEvent BeforeControlPrint = {read=FBeforeControlPrint, write=FBeforeControlPrint};
	__property TGenerateAfterEvent AfterControlPrint = {read=FAfterControlPrint, write=FAfterControlPrint};
	__property TGenerateBeforeEvent BeforeBandPrint = {read=FBeforeBandPrint, write=FBeforeBandPrint};
	__property TGenerateAfterEvent AfterBandPrint = {read=FAfterBandPrint, write=FAfterBandPrint};
	__property AnimatedStatus = {default=1};
	__property Frame;
	__property PrinterSetting;
	__property Font;
	__property OnGetVariable;
	__property Options = {default=1};
};


typedef TSMRRegisterControl *PSMRRegisterControl;

struct DECLSPEC_DRECORD TSMRRegisterControl
{
public:
	System::UnicodeString ControlClassName;
	int HintIndex;
	System::UnicodeString Hint;
	System::LongInt hInstance;
	int intCursorIndex;
};


//-- var, const, procedure ---------------------------------------------------
static _DELPHI_CONST System::Int8 intPointHeight = System::Int8(0x5);
extern DELPHI_PACKAGE System::Classes::TList* lstSMRControls;
extern DELPHI_PACKAGE int __fastcall GetUnsignedCursor(void);
extern DELPHI_PACKAGE void __fastcall UpdateDesigner(Vcl::Controls::TControl* ctrl, int intMessage, int WParam, int LParam);
extern DELPHI_PACKAGE TSMRBand* __fastcall GetBandByControl(TSMRControl* cntr);
extern DELPHI_PACKAGE void __fastcall RegisterSMRControl(TSMRControlClass ASMRControlClass, int AHintIndex, System::UnicodeString AHint, System::LongInt AHInstance);
extern DELPHI_PACKAGE void __fastcall UnRegisterSMRControl(TSMRControlClass ASMRControlClass);
}	/* namespace Smrbase */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMRBASE)
using namespace Smrbase;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMRBaseHPP
