﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'PrintSM.pas' rev: 37.00 (Windows)

#ifndef PrintSMHPP
#define PrintSMHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <Vcl.Controls.hpp>
#include <SMPrntr.hpp>
#include <SMRTypes.hpp>
#include <SMRPESet.hpp>
#include <SMRExprt.hpp>
#include <SMRCnst.hpp>
#include <SMRPars.hpp>
#include <Data.DB.hpp>
#include <System.UITypes.hpp>
#include <System.Types.hpp>

//-- user supplied -----------------------------------------------------------

namespace Printsm
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMRLanguage;
class DELPHICLASS TPageInfo;
class DELPHICLASS TSMRFrame;
class DELPHICLASS TSMPrintBaseComponent;
class DELPHICLASS TSMPrintComponent;
class DELPHICLASS TSMRCompositeReport;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TSMRLangID : unsigned char { lnEnglish, lnRussian, lnUkrainian, lnGerman, lnFrench, lnSpanish, lnSwedish, lnCzech, lnDutch };

class PASCALIMPLEMENTATION TSMRLanguage : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	bool FAutoDetect;
	TSMRLangID FLanguageID;
	bool FAutoDetected;
	TSMRLangID FLangIDByAutoDetect;
	void __fastcall AutoDetectLangID();
	
public:
	__fastcall TSMRLanguage();
	TSMRLangID __fastcall GetLangID();
	
__published:
	__property bool AutoDetect = {read=FAutoDetect, write=FAutoDetect, default=0};
	__property TSMRLangID LanguageID = {read=FLanguageID, write=FLanguageID, default=0};
public:
	/* TPersistent.Destroy */ inline __fastcall virtual ~TSMRLanguage() { }
	
};


class PASCALIMPLEMENTATION TPageInfo : public System::TObject
{
	typedef System::TObject inherited;
	
private:
	int FPageWidth;
	int FPageHeight;
	void __fastcall SetPageWidth(int Value);
	void __fastcall SetPageHeight(int Value);
	
public:
	int intNumPage;
	int intNumBar;
	int OffsetLeft;
	int OffsetRight;
	int OffsetTop;
	int OffsetBottom;
	Vcl::Graphics::TMetafile* Data;
	__property int PageWidth = {read=FPageWidth, write=SetPageWidth, nodefault};
	__property int PageHeight = {read=FPageHeight, write=SetPageHeight, nodefault};
public:
	/* TObject.Create */ inline __fastcall TPageInfo() : System::TObject() { }
	/* TObject.Destroy */ inline __fastcall virtual ~TPageInfo() { }
	
};


enum DECLSPEC_DENUM TStatus : unsigned char { stIdle, stPrinting, stPrinted };

typedef void __fastcall (__closure *TPageEvent)(System::TObject* Sender, int Page, int Bar);

enum DECLSPEC_DENUM Printsm__3 : unsigned char { ftTop, ftBottom, ftLeft, ftRight };

typedef System::Set<Printsm__3, Printsm__3::ftTop, Printsm__3::ftRight> TSMFrameType;

enum DECLSPEC_DENUM TSMPicType : unsigned char { btNone, btCenter, btStretch, btTile, btTileAsFrame, btCorners };

class PASCALIMPLEMENTATION TSMRFrame : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	bool FBottom;
	bool FLeft;
	bool FRight;
	bool FTop;
	Vcl::Controls::TControl* FParent;
	Vcl::Graphics::TPenStyle FPenStyle;
	int FWidth;
	System::Uitypes::TColor FColor;
	System::Uitypes::TColor FBackColor;
	Vcl::Graphics::TPicture* FPicture;
	TSMPicType FPicType;
	void __fastcall SetColor(int Index, System::Uitypes::TColor Value);
	void __fastcall SetParent(Vcl::Controls::TControl* Value);
	void __fastcall SetStyle(Vcl::Graphics::TPenStyle Value);
	void __fastcall SetValue(int Index, bool Value);
	void __fastcall SetWidth(int Value);
	TSMFrameType __fastcall GetFrameType();
	void __fastcall SetFrameType(TSMFrameType Value);
	void __fastcall SetPicture(Vcl::Graphics::TPicture* Value);
	
protected:
	void __fastcall SetPen(Vcl::Graphics::TPen* Value);
	
public:
	__fastcall TSMRFrame();
	__fastcall virtual ~TSMRFrame();
	bool __fastcall AnyFrame();
	int __fastcall GetFrameWidth();
	void __fastcall DrawFrame(Vcl::Graphics::TCanvas* ACanvas, const Winapi::Windows::TRect &ARect);
	__property Vcl::Controls::TControl* Parent = {read=FParent, write=SetParent};
	__property bool DrawTop = {read=FTop, write=SetValue, index=0, nodefault};
	__property bool DrawBottom = {read=FBottom, write=SetValue, index=1, nodefault};
	__property bool DrawLeft = {read=FLeft, write=SetValue, index=2, nodefault};
	__property bool DrawRight = {read=FRight, write=SetValue, index=3, nodefault};
	
__published:
	__property System::Uitypes::TColor Color = {read=FColor, write=SetColor, index=0, default=0};
	__property Vcl::Graphics::TPenStyle Style = {read=FPenStyle, write=SetStyle, default=0};
	__property int Width = {read=FWidth, write=SetWidth, default=1};
	__property TSMFrameType FrameType = {read=GetFrameType, write=SetFrameType, default=0};
	__property System::Uitypes::TColor BackColor = {read=FBackColor, write=SetColor, index=1, default=16777215};
	__property Vcl::Graphics::TPicture* Picture = {read=FPicture, write=SetPicture};
	__property TSMPicType PicType = {read=FPicType, write=FPicType, default=0};
};


enum DECLSPEC_DENUM TSMROption : unsigned char { roDisableControls };

typedef System::Set<TSMROption, TSMROption::roDisableControls, TSMROption::roDisableControls> TSMROptions;

class PASCALIMPLEMENTATION TSMPrintBaseComponent : public System::Classes::TComponent
{
	typedef System::Classes::TComponent inherited;
	
private:
	System::Classes::TNotifyEvent FBeginDoc;
	System::Classes::TNotifyEvent FEndDoc;
	TPageEvent FBeginPage;
	TPageEvent FEndPage;
	bool FPrepared;
	TStatus FStatus;
	System::Classes::TList* FPages;
	Smrexprt::TSMProperty* FSMProperty;
	TSMRFrame* FFrame;
	bool FAnimatedStatus;
	TSMRLanguage* FLanguage;
	Smprntr::TSMRPrinter* FPrinterSetting;
	Smprntr::TSMRPrinter* FOldPrinterSetting;
	System::Classes::TNotifyEvent FOnBeforePreview;
	System::Classes::TNotifyEvent FOnPreview;
	System::Classes::TNotifyEvent FOnAfterPreview;
	System::Classes::TNotifyEvent FOnBeforePrint;
	System::Classes::TNotifyEvent FOnAfterPrint;
	bool FTwoPass;
	Smrtypes::TSMRVariables* FVariables;
	Smrtypes::TSMROutlines* FOutlines;
	Smrpars::TGetVariableEvent FOnGetVariable;
	TSMROptions FOptions;
	System::Classes::THelpContext FHelpContext;
	System::Classes::TNotifyEvent FOnBeforeFormShow;
	void __fastcall SetVariables(Smrtypes::TSMRVariables* Value);
	void __fastcall SetOutlines(Smrtypes::TSMROutlines* Value);
	void __fastcall SetLanguage(TSMRLanguage* Value);
	void __fastcall SetPrinterSettings(Smprntr::TSMRPrinter* Value);
	void __fastcall SetFrame(TSMRFrame* Value);
	void __fastcall SavePrinter();
	void __fastcall RestorePrinter();
	TPageInfo* __fastcall GetPage(int intPg, int intBr);
	void __fastcall DrawLogo();
	void __fastcall SetSMProperty(Smrexprt::TSMProperty* Value);
	
protected:
	int intMaxPageHeight;
	int intLastPageHeight;
	int intCurHeight;
	int intCurPassNumber;
	int intNumPages;
	int intNumBars;
	int __fastcall GetNumPages();
	int __fastcall GetNumBars();
	void __fastcall FreePages();
	void __fastcall PrintStart();
	void __fastcall PrintEnd();
	void __fastcall PrepareStart();
	void __fastcall PrepareEnd();
	virtual void __fastcall PrepareReport();
	void __fastcall InternalPreview(bool WithPrepare, Vcl::Controls::TWinControl* ParentControl);
	System::Variant __fastcall GetSysDataValue(Smrcnst::TSMRSysDataType sdType);
	virtual int __fastcall GetPageNoCountBy();
	virtual int __fastcall GetPageNoStartAt();
	virtual int __fastcall GetCurColumn();
	virtual int __fastcall GetColumnNumber();
	virtual void __fastcall SMRGetVariable(System::TObject* Sender, System::UnicodeString VariableName, bool &Accept, Data::Db::TFieldType &VariableType, System::Variant &Value);
	__property bool TwoPass = {read=FTwoPass, write=FTwoPass, default=0};
	__property System::Classes::TNotifyEvent OnBeforeFormShow = {read=FOnBeforeFormShow, write=FOnBeforeFormShow};
	
public:
	System::UnicodeString ProductVersion;
	int intCurPage;
	int intCurBar;
	Vcl::Graphics::TMetafileCanvas* MFCanvas;
	__fastcall virtual TSMPrintBaseComponent(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMPrintBaseComponent();
	TPageInfo* __fastcall CurrentPage();
	virtual void __fastcall BeginDoc();
	virtual void __fastcall EndDoc();
	virtual void __fastcall NewPage(bool isNewBar);
	void __fastcall Prepare();
	void __fastcall PrintPages(System::Classes::TStrings* lstValidPages);
	void __fastcall PrintReport();
	void __fastcall Print();
	void __fastcall Preview();
	void __fastcall PreviewParentedControl(Vcl::Controls::TWinControl* ParentControl);
	void __fastcall PreviewParentedControlPreparedReport(Vcl::Controls::TWinControl* ParentControl);
	void __fastcall PreviewPreparedReport();
	void __fastcall LoadPreparedReportFromStream(System::Classes::TStream* AStream);
	void __fastcall LoadPreparedReport(const System::UnicodeString FileName);
	void __fastcall SavePreparedReportToStream(System::Classes::TStream* AStream);
	void __fastcall SavePreparedReport(const System::UnicodeString FileName);
	void __fastcall SavePreparedPages(const System::UnicodeString FileName, bool IsSeparatePages, System::Classes::TStrings* lstValidPages);
	void __fastcall SavePageToFile(System::UnicodeString &AFileName);
	void __fastcall ExportTo(System::UnicodeString FName, bool IsSeparatePages, System::Classes::TStrings* lstValidPages, Smrexprt::TSMRExportClass smreFilter);
	void __fastcall About();
	System::LongInt __fastcall GetLanguageShift();
	System::UnicodeString __fastcall F0D0();
	__property TPageInfo* Pages[int intPg][int intBr] = {read=GetPage};
	__property int NumPages = {read=GetNumPages, nodefault};
	__property int NumBars = {read=GetNumBars, nodefault};
	__property bool AnimatedStatus = {read=FAnimatedStatus, write=FAnimatedStatus, default=1};
	__property TSMRFrame* Frame = {read=FFrame, write=SetFrame};
	__property Smprntr::TSMRPrinter* PrinterSetting = {read=FPrinterSetting, write=SetPrinterSettings};
	__property Smrtypes::TSMROutlines* Outlines = {read=FOutlines, write=SetOutlines};
	__property Smrtypes::TSMRVariables* Variables = {read=FVariables, write=SetVariables};
	__property Smrpars::TGetVariableEvent OnGetVariable = {read=FOnGetVariable, write=FOnGetVariable};
	__property TSMROptions Options = {read=FOptions, write=FOptions, default=1};
	
__published:
	__property TSMRLanguage* Language = {read=FLanguage, write=SetLanguage};
	__property Smrexprt::TSMProperty* SMProperty = {read=FSMProperty, write=SetSMProperty};
	__property System::Classes::THelpContext HelpContext = {read=FHelpContext, write=FHelpContext, default=0};
	__property System::Classes::TNotifyEvent OnBeginDoc = {read=FBeginDoc, write=FBeginDoc};
	__property System::Classes::TNotifyEvent OnEndDoc = {read=FEndDoc, write=FEndDoc};
	__property TPageEvent OnBeginPage = {read=FBeginPage, write=FBeginPage};
	__property TPageEvent OnEndPage = {read=FEndPage, write=FEndPage};
	__property System::Classes::TNotifyEvent OnPreview = {read=FOnPreview, write=FOnPreview};
	__property System::Classes::TNotifyEvent OnBeforePreview = {read=FOnBeforePreview, write=FOnBeforePreview};
	__property System::Classes::TNotifyEvent OnAfterPreview = {read=FOnAfterPreview, write=FOnAfterPreview};
	__property System::Classes::TNotifyEvent OnBeforePrint = {read=FOnBeforePrint, write=FOnBeforePrint};
	__property System::Classes::TNotifyEvent OnAfterPrint = {read=FOnAfterPrint, write=FOnAfterPrint};
};


class PASCALIMPLEMENTATION TSMPrintComponent : public TSMPrintBaseComponent
{
	typedef TSMPrintBaseComponent inherited;
	
private:
	Vcl::Graphics::TFont* FFont;
	void __fastcall SetFont(Vcl::Graphics::TFont* Value);
	
public:
	__fastcall virtual TSMPrintComponent(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMPrintComponent();
	__property Vcl::Graphics::TFont* Font = {read=FFont, write=SetFont};
	
__published:
	__property TwoPass = {default=0};
};


class PASCALIMPLEMENTATION TSMRCompositeReport : public TSMPrintBaseComponent
{
	typedef TSMPrintBaseComponent inherited;
	
private:
	System::Classes::TList* FReports;
	
public:
	__fastcall virtual TSMRCompositeReport(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMRCompositeReport();
	virtual void __fastcall PrepareReport();
	int __fastcall AddReport(TSMPrintBaseComponent* SMRep);
	void __fastcall RemoveReport(int i);
	void __fastcall ClearReports();
	__property System::Classes::TList* Reports = {read=FReports, write=FReports};
};


//-- var, const, procedure ---------------------------------------------------
}	/* namespace Printsm */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_PRINTSM)
using namespace Printsm;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// PrintSMHPP
