﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'SMBarCode.pas' rev: 37.00 (Windows)

#ifndef SMBarCodeHPP
#define SMBarCodeHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <Winapi.Windows.hpp>
#include <Winapi.Messages.hpp>
#include <System.SysUtils.hpp>
#include <System.Classes.hpp>
#include <Vcl.Graphics.hpp>
#include <Vcl.Controls.hpp>
#include <Vcl.Forms.hpp>
#include <Vcl.Dialogs.hpp>
#include <System.UITypes.hpp>
#include <SMRBase.hpp>
#include <System.Types.hpp>
#include <Vcl.Menus.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smbarcode
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMBarCode;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TBarCodeType : unsigned char { bcCode39, bcInterleaved2of5, bcPostnet, bcUPCA };

enum DECLSPEC_DENUM TBarType : unsigned char { btNarrow, btWide };

class PASCALIMPLEMENTATION TSMBarCode : public Smrbase::TSMRControl
{
	typedef Smrbase::TSMRControl inherited;
	
private:
	TBarCodeType FBarCodeType;
	int FNarrowWidth;
	int FWideWidth;
	bool FVertical;
	System::UnicodeString FValue;
	System::UnicodeString FExpression;
	void __fastcall SetValue(System::UnicodeString AValue);
	void __fastcall SetExpression(System::UnicodeString AValue);
	System::UnicodeString __fastcall GetBarCode();
	System::Byte __fastcall FindCode(System::WideChar ch, System::WideChar *arrChar, const System::NativeInt arrChar_High, System::Byte *arrCode, const System::NativeInt arrCode_High, int &intIndex);
	void __fastcall DrawCode39(Vcl::Graphics::TCanvas* ACanvas);
	void __fastcall DrawInterleaved2of5(Vcl::Graphics::TCanvas* ACanvas);
	void __fastcall DrawPostnet(Vcl::Graphics::TCanvas* ACanvas);
	void __fastcall DrawUPCA(Vcl::Graphics::TCanvas* ACanvas);
	void __fastcall DrawUPCLeftBars(Vcl::Graphics::TCanvas* ACanvas, System::UnicodeString NumSys);
	void __fastcall DrawUPCCenterBars(Vcl::Graphics::TCanvas* ACanvas);
	void __fastcall DrawUPCRightBars(Vcl::Graphics::TCanvas* ACanvas, System::UnicodeString Chk);
	
protected:
	int intRecLeft;
	int intRecTop;
	int intRecHeight;
	int intRecWidth;
	void __fastcall DrawBarLine(Vcl::Graphics::TCanvas* ACanvas, TBarType BarType, bool boolDraw, bool IsHalf);
	void __fastcall DrawBarString(Vcl::Graphics::TCanvas* ACanvas, System::UnicodeString BarString);
	void __fastcall DrawPostnetString(Vcl::Graphics::TCanvas* ACanvas, System::UnicodeString BarString);
	
public:
	__fastcall virtual TSMBarCode(System::Classes::TComponent* AOwner);
	virtual int __fastcall Draw(Vcl::Graphics::TCanvas* ACanvas, Winapi::Windows::TRect &ARect, int intBandHeight, System::Word Flags);
	
__published:
	__property TBarCodeType BarCodeType = {read=FBarCodeType, write=FBarCodeType, nodefault};
	__property System::UnicodeString Value = {read=FValue, write=SetValue};
	__property System::UnicodeString Expression = {read=FExpression, write=SetExpression};
	__property bool Vertical = {read=FVertical, write=FVertical, nodefault};
	__property int NarrowWidth = {read=FNarrowWidth, write=FNarrowWidth, nodefault};
	__property int WideWidth = {read=FWideWidth, write=FWideWidth, nodefault};
	__property Align = {default=0};
	__property Caption = {default=0};
	__property Color = {default=-16777211};
	__property DragCursor = {default=-12};
	__property DragMode = {default=0};
	__property Enabled = {default=1};
	__property Font;
	__property ParentColor = {default=1};
	__property ParentFont = {default=1};
	__property ParentShowHint = {default=1};
	__property PopupMenu;
	__property ShowHint;
	__property Visible = {default=1};
	__property OnClick;
	__property OnDblClick;
	__property OnDragDrop;
	__property OnDragOver;
	__property OnEndDrag;
	__property OnMouseDown;
	__property OnMouseMove;
	__property OnMouseUp;
	__property OnStartDrag;
public:
	/* TSMRControl.Destroy */ inline __fastcall virtual ~TSMBarCode() { }
	
};


//-- var, const, procedure ---------------------------------------------------
}	/* namespace Smbarcode */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMBARCODE)
using namespace Smbarcode;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// SMBarCodeHPP
