unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, smiupdate, ComCtrls;

type
  TfrmMain = class(TForm)
    gbOptions: TGroupBox;
    edHost: TEdit;
    lblHostName: TLabel;
    btnExecute: TButton;
    btnAbout: TButton;
    imgLogo: TImage;
    lblPort: TLabel;
    edPort: TEdit;
    MemoResults: TMemo;
    pnlStatus: TPanel;
    lblURL: TLabel;
    SMWebUpdater: TSMWebUpdater;
    lblUserID: TLabel;
    edUserID: TEdit;
    lblPassword: TLabel;
    edPassword: TEdit;
    lblFiles: TLabel;
    edRemoteFileName: TEdit;
    lblLocalFileName: TLabel;
    edLocalFileName: TEdit;
    lblWEBSettings: TLabel;
    cbService: TComboBox;
    procedure btnExecuteClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lblURLClick(Sender: TObject);
    procedure SMWebUpdaterAfterExecute(Sender: TObject);
    procedure cbServiceChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}
{$R winxp.res}

uses ShellAPI, SMInCnst;

procedure TfrmMain.btnAboutClick(Sender: TObject);
begin
  AboutSMInet
end;

procedure TfrmMain.lblURLClick(Sender: TObject);
begin
  ShellExecute(0, 'open', PChar((Sender as TLabel).Caption), nil, nil, SW_SHOWNORMAL);
end;

procedure TfrmMain.btnExecuteClick(Sender: TObject);
begin
  SMWebUpdater.Port := StrToIntDef(edPort.Text, SMWebUpdater.Port);
  SMWebUpdater.Host := edHost.Text;
  SMWebUpdater.User := edUserID.Text;
  SMWebUpdater.Password := edPassword.Text;

  SMWebUpdater.RemoteFileName := edRemoteFileName.Text;
  SMWebUpdater.LocalFileName := edLocalFileName.Text;

  SMWebUpdater.Execute
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  Application.Title := Caption;
  cbService.ItemIndex := Ord(SMWebUpdater.Service);
  edHost.Text := SMWebUpdater.Host;
  edPort.Text := IntToStr(SMWebUpdater.Port);
  edUserID.Text := SMWebUpdater.User;
  edPassword.Text := SMWebUpdater.Password;

  edRemoteFileName.Text := SMWebUpdater.RemoteFileName;
  edLocalFileName.Text := ExpandFileName(SMWebUpdater.LocalFileName);
end;

procedure TfrmMain.SMWebUpdaterAfterExecute(Sender: TObject);
var
  s: string;
begin
  case SMWebUpdater.Status of
    isFinished: s := 'File updated succesfully';
    isFailed: s := 'Error is occured during file updating.';
    isSkipped: s := 'File is not changed or not found';
  else
    s := '';
  end;

  if (s <> '') then
    ShowMessage(s)
end;

procedure TfrmMain.cbServiceChange(Sender: TObject);
begin
  SMWebUpdater.Service := TSMIService(cbService.ItemIndex);
  edPort.Text := IntToStr(SMWebUpdater.Port);
end;

end.
