unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, smiupdate, ComCtrls, Jpeg, smiimage;

type
  TfrmMain = class(TForm)
    gbOptions: TGroupBox;
    edHost: TEdit;
    lblHostName: TLabel;
    btnExecute: TButton;
    btnAbout: TButton;
    imgLogo: TImage;
    pnlStatus: TPanel;
    lblURL: TLabel;
    lblFiles: TLabel;
    edRemoteFileName: TEdit;
    lblWEBSettings: TLabel;
    cbService: TComboBox;
    lblProgress: TLabel;
    SMRemoteImage: TSMRemoteImage;
    gbPreview: TGroupBox;
    pbStatus: TProgressBar;
    imgRemote: TImage;
    procedure btnExecuteClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lblURLClick(Sender: TObject);
    procedure SMWebUpdaterProgress(Sender: TObject; CurValue,
      MaxValue: Integer; var Abort: Boolean);
    procedure SMWebUpdaterAfterExecute(Sender: TObject);
    procedure SMWebUpdaterBeforeExecute(Sender: TObject);
    procedure SMWebUpdaterActionChange(Sender: TObject);
    procedure SMWebUpdaterStatusChange(Sender: TObject);
    procedure cbServiceChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}
{$R winxp.res}

uses ShellAPI, SMInCnst;

procedure TfrmMain.btnAboutClick(Sender: TObject);
begin
  AboutSMInet
end;

procedure TfrmMain.lblURLClick(Sender: TObject);
begin
  ShellExecute(0, 'open', PChar((Sender as TLabel).Caption), nil, nil, SW_SHOWNORMAL);
end;

procedure TfrmMain.btnExecuteClick(Sender: TObject);
begin
  SMRemoteImage.Host := edHost.Text;

  SMRemoteImage.RemoteFileName := edRemoteFileName.Text;
  SMRemoteImage.Active := not SMRemoteImage.Active;

  if SMRemoteImage.Active then
  begin
    btnExecute.Caption := 'Stop';
    ShowMessage('This image will attempt to refresh every 60 seconds')
  end
  else
    btnExecute.Caption := 'Start';
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  Application.Title := Caption;
  cbService.ItemIndex := Ord(SMRemoteImage.Service);
  edHost.Text := SMRemoteImage.Host;

  edRemoteFileName.Text := SMRemoteImage.RemoteFileName;
end;

procedure TfrmMain.SMWebUpdaterProgress(Sender: TObject; CurValue,
  MaxValue: Integer; var Abort: Boolean);
begin
  pbStatus.Max := MaxValue;
  pbStatus.Position := CurValue;
  lblProgress.Caption := 'Downloaded ' + IntToStr(CurValue) + ' of ' + IntToStr(MaxValue) + ' bytes (' + IntToStr(CurValue*100 div MaxValue) + '%)';

  Application.ProcessMessages
end;

procedure TfrmMain.SMWebUpdaterAfterExecute(Sender: TObject);
begin
  pbStatus.Visible := False;
end;

procedure TfrmMain.SMWebUpdaterBeforeExecute(Sender: TObject);
begin
  pbStatus.Visible := True;
  pbStatus.Position := 0;

  Application.ProcessMessages
end;

procedure TfrmMain.SMWebUpdaterActionChange(Sender: TObject);
const
  arrAction: array[TSMIAction] of string = (
                'Idle',
                'Connecting...',
                'Connected.',
                'Disconnecting...',
                'Disconnected.',
                'File search...',
                'File found.',
                'Comparing...',
                'Compared.',
                'Downloading...',
                'Downloaded.');
begin
  lblProgress.Caption := arrAction[SMRemoteImage.Action];

  Application.ProcessMessages
end;

procedure TfrmMain.SMWebUpdaterStatusChange(Sender: TObject);
const
  arrStatus: array[TSMIStatus] of string = (
             'In progress...',
             'Completed.',
             'Failed.',
             'Skipped',
             'Remote file is not found');
begin
  lblProgress.Caption := arrStatus[SMRemoteImage.Status];

  Application.ProcessMessages
end;

procedure TfrmMain.cbServiceChange(Sender: TObject);
begin
  SMRemoteImage.Service := TSMIService(cbService.ItemIndex);
end;

end.
