unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, SMInBase, SMIUPS, ComCtrls, ScktComp, Grids;

type
  TfrmMain = class(TForm)
    gbOptions: TGroupBox;
    btnExecute: TButton;
    btnAbout: TButton;
    lblPackage: TLabel;
    edPackage: TEdit;
    SMUPSTracker: TSMUPSTracker;
    imgLogo: TImage;
    rbCurrentStatus: TRadioButton;
    rbFullTracking: TRadioButton;
    StatusBar: TStatusBar;
    pcDetails: TPageControl;
    tsShipment: TTabSheet;
    sgShipment: TStringGrid;
    tsActivity: TTabSheet;
    sgActivity: TStringGrid;
    procedure btnExecuteClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure SMUPSTrackerConnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure SMUPSTrackerConnecting(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure SMUPSTrackerDisconnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure SMUPSTrackerError(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure SMUPSTrackerLookup(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure SMUPSTrackerReceiveTextFromSocket(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure SMUPSTrackerSendTextToSocket(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure rbCurrentStatusClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}
{$R winxp.res}

uses SMInCnst, SMIUtil;

procedure TfrmMain.btnExecuteClick(Sender: TObject);
var
  i: Integer;
begin
  {define a package number}
  SMUPSTracker.TrackingNumber := edPackage.Text;

  {type of tracking}
  if rbCurrentStatus.Checked then
    SMUPSTracker.TrackingType := upsCurrentStatus
  else
    SMUPSTracker.TrackingType := upsFullTracking;

  {track a package}
  SMUPSTracker.Execute;

  {copy details to string grids}
  {1. shipment details}
  sgShipment.Cells[0, 0] := 'Tracking Number';
  sgShipment.Cells[1, 0] := SMUPSTracker.GetUPSStatus(ssTrackingNumber);
  sgShipment.Cells[0, 1] := 'Last Activity';
  sgShipment.Cells[1, 1] := FormatDateTime('dddd, mmm dd, yyyy, tt', SMUPSTracker.GetActivityAsDateTime);
  sgShipment.Cells[0, 2] := 'Last Status';
  sgShipment.Cells[1, 2] := SMUPSTracker.GetUPSStatus(ssLastStatus);
  sgShipment.Cells[0, 4] := 'Service Type';
  sgShipment.Cells[1, 4] := SMUPSTracker.GetUPSStatus(ssServiceType);
  sgShipment.Cells[0, 5] := 'Weight';
  sgShipment.Cells[1, 5] := SMUPSTracker.GetUPSStatus(ssWeight) + ' ' + SMUPSTracker.GetUPSStatus(ssWeightUnits);
  sgShipment.Cells[0, 6] := 'Signed By';
  sgShipment.Cells[1, 6] := SMUPSTracker.GetUPSStatus(ssSignedBy);
  sgShipment.Cells[0, 7] := 'Location';
  sgShipment.Cells[1, 7] := SMUPSTracker.GetUPSStatus(ssLocation);
  sgShipment.Cells[0, 8] := 'Place';
  sgShipment.Cells[1, 8] := SMUPSTracker.GetUPSStatus(ssPlace);

  {2. activity records}
  sgActivity.RowCount := SMUPSTracker.Activity.Count;
  sgActivity.Cells[0, 0] := 'Date/Time';
  sgActivity.Cells[1, 0] := 'Location';
  sgActivity.Cells[2, 0] := 'Comments';
  for i := 1 to SMUPSTracker.Activity.Count-1 do
  begin
    sgActivity.Cells[0, i] := GetColumn(SMUPSTracker.Activity[i], 4, '%') + ' ' +
                              GetColumn(SMUPSTracker.Activity[i], 5, '%');
    sgActivity.Cells[1, i] := GetColumn(SMUPSTracker.Activity[i], 13, '%') + ' ' +
                              GetColumn(SMUPSTracker.Activity[i], 14, '%') + ' ' +
                              GetColumn(SMUPSTracker.Activity[i], 15, '%') + ' ' +
                              GetColumn(SMUPSTracker.Activity[i], 16, '%');
    sgActivity.Cells[2, i] := GetColumn(SMUPSTracker.Activity[i], 3, '%');

//    sgActivity.Cells[0, i] := SMUPSTracker.Activity[i]
  end;
end;

procedure TfrmMain.btnAboutClick(Sender: TObject);
begin
  AboutSMInet
end;

procedure TfrmMain.SMUPSTrackerConnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Connected.';
end;

procedure TfrmMain.SMUPSTrackerConnecting(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Connecting...';
end;

procedure TfrmMain.SMUPSTrackerDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Disconnected.';
end;

procedure TfrmMain.SMUPSTrackerError(Sender: TObject;
  Socket: TCustomWinSocket; ErrorEvent: TErrorEvent;
  var ErrorCode: Integer);
begin
  StatusBar.SimpleText := 'Error: ' + IntToStr(ErrorCode);
end;

procedure TfrmMain.SMUPSTrackerLookup(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Lookup...';
end;

procedure TfrmMain.SMUPSTrackerReceiveTextFromSocket(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Receiving...';
end;

procedure TfrmMain.SMUPSTrackerSendTextToSocket(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Sending...';
end;

procedure TfrmMain.rbCurrentStatusClick(Sender: TObject);
begin
  pcDetails.ActivePage := tsShipment;
  tsActivity.TabVisible := rbFullTracking.Checked;
end;

end.
