unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, scktcomp, SMInBase, SMIDNS, ExtCtrls, SMIHTTP, Grids;

type
  TfrmHTTPClient = class(TForm)
    edDomain: TEdit;
    lblDomainName: TLabel;
    btnExecute: TButton;
    btnAbout: TButton;
    imgLogo: TImage;
    lblPort: TLabel;
    edPort: TEdit;
    pnlStatus: TPanel;
    lblURL: TLabel;
    SMIHTTPClient: TSMIHTTPClient;
    memoHTTP: TMemo;
    sgResponce: TStringGrid;
    lblRequest: TLabel;
    edRequest: TEdit;
    lblAction: TLabel;
    cbAction: TComboBox;
    gbHTTP: TGroupBox;
    cbRemoveHeader: TCheckBox;
    cbUseProxy: TCheckBox;
    edProxyServer: TEdit;
    procedure btnExecuteClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lblURLClick(Sender: TObject);
    procedure SMWhoIsLookup(Sender: TObject; Socket: TCustomWinSocket);
    procedure SMWhoIsReceiveTextFromSocket(Sender: TObject; s: String);
    procedure SMWhoIsSendTextToSocket(Sender: TObject; s: String);
    procedure SMWhoIsConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure SMWhoIsConnecting(Sender: TObject; Socket: TCustomWinSocket);
    procedure SMWhoIsDisconnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure SMWhoIsError(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmHTTPClient: TfrmHTTPClient;

implementation

{$R *.DFM}
{$R winxp.res}

uses ShellAPI, SMInCnst;

procedure TfrmHTTPClient.btnExecuteClick(Sender: TObject);
var
  i, j: Integer;
begin
  SMIHTTPClient.Host := edDomain.Text;
  SMIHTTPClient.Request := edRequest.Text;
  SMIHTTPClient.Action := TSMIHTTPAction(cbAction.ItemIndex);
  SMIHTTPClient.Port := StrToIntDef(edPort.Text, SMIHTTPClient.Port);
  SMIHTTPClient.ClientType := ctBlocking;
  SMIHTTPClient.RemoveHeaders := cbRemoveHeader.Checked;
  if cbUseProxy.Checked then
    SMIHTTPClient.Proxy.Server := edProxyServer.Text
  else
    SMIHTTPClient.Proxy.Server := '';

  {show an answer from http-server}
  MemoHTTP.Lines.Text := SMIHTTPClient.Execute;

  {display detailed response header which is received from http-server}
  for i := 0 to SMIHTTPClient.ResponseHeaders.Count-1 do
  begin
    j := Pos(':', SMIHTTPClient.ResponseHeaders[i]);
    if j > 0 then
    begin
      sgResponce.Cells[0, i+1] := Copy(SMIHTTPClient.ResponseHeaders[i], 1, j-1);
      sgResponce.Cells[1, i+1] := Copy(SMIHTTPClient.ResponseHeaders[i], j+1, Length(SMIHTTPClient.ResponseHeaders[i]));
    end
    else
      sgResponce.Cells[1, i+1] := SMIHTTPClient.ResponseHeaders[i];
  end;
end;

procedure TfrmHTTPClient.btnAboutClick(Sender: TObject);
begin
  AboutSMInet
end;

procedure TfrmHTTPClient.FormCreate(Sender: TObject);
begin
  Application.Title := Caption;
  sgResponce.Cells[0, 0] := 'Response';
  sgResponce.Cells[1, 0] := 'Value';

  edPort.Text := IntToStr(SMIHTTPClient.Port);
  cbAction.ItemIndex := Ord(SMIHTTPClient.Action)
end;

procedure TfrmHTTPClient.lblURLClick(Sender: TObject);
begin
  ShellExecute(0, 'open', PChar((Sender as TLabel).Caption), nil, nil, SW_SHOWNORMAL);
end;

procedure TfrmHTTPClient.SMWhoIsLookup(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  pnlStatus.Caption := 'Lookup...';
end;

procedure TfrmHTTPClient.SMWhoIsReceiveTextFromSocket(Sender: TObject;
  s: String);
begin
  pnlStatus.Caption := 'Receiving information...';
end;

procedure TfrmHTTPClient.SMWhoIsSendTextToSocket(Sender: TObject; s: String);
begin
  pnlStatus.Caption := 'Query sending...';
end;

procedure TfrmHTTPClient.SMWhoIsConnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  pnlStatus.Caption := 'Connected.';
end;

procedure TfrmHTTPClient.SMWhoIsConnecting(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  pnlStatus.Caption := 'Connecting...';
end;

procedure TfrmHTTPClient.SMWhoIsDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  pnlStatus.Caption := 'Disconnected.';
end;

procedure TfrmHTTPClient.SMWhoIsError(Sender: TObject; Socket: TCustomWinSocket;
  ErrorEvent: TErrorEvent; var ErrorCode: Integer);
begin
  MemoHTTP.Lines.Add(IntToStr(ErrorCode) + ' ' + FormatDateTime('c', Now()))
end;

end.
