﻿// CodeGear C++Builder
// Copyright (c) 1995, 2025 by Embarcadero Technologies, Inc.
// All rights reserved

// (DO NOT EDIT: machine generated header) 'smiupdate.pas' rev: 37.00 (Windows)

#ifndef smiupdateHPP
#define smiupdateHPP

#pragma delphiheader begin
#pragma option push
#if defined(__BORLANDC__) && !defined(__clang__)
#pragma option -w-      // All warnings off
#pragma option -Vx      // Zero-length empty class member 
#endif
#pragma pack(push,8)
#include <System.hpp>
#include <SysInit.hpp>
#include <System.Classes.hpp>
#include <Winapi.Windows.hpp>
#include <Vcl.Controls.hpp>
#include <Vcl.Graphics.hpp>
#include <Winapi.WinInet.hpp>
#include <SMInBase.hpp>
#include <SMInStat.hpp>
#include <Vcl.Dialogs.hpp>

//-- user supplied -----------------------------------------------------------

namespace Smiupdate
{
//-- forward type declarations -----------------------------------------------
class DELPHICLASS TSMInetStatusDialog;
class DELPHICLASS TSMCustomWebComponent;
class DELPHICLASS TSMCustomWebUpdater;
class DELPHICLASS TSMWebUpdater;
//-- type declarations -------------------------------------------------------
enum DECLSPEC_DENUM TSMIService : unsigned char { isHTTP, isHTTPS, isFTP, isNetwork };

enum DECLSPEC_DENUM TSMIStatus : unsigned char { isInProgress, isFinished, isFailed, isSkipped, isNotFound };

enum DECLSPEC_DENUM TSMIAction : unsigned char { iaIdle, iaConnecting, iaConnected, iaDisconnecting, iaDisconnected, iaFileSearch, iaFileFound, iaComparing, iaCompared, iaDownloading, iaDownloaded };

typedef void __fastcall (__closure *TSMIProgress)(System::TObject* Sender, int CurValue, int MaxValue, bool &Abort);

class PASCALIMPLEMENTATION TSMInetStatusDialog : public System::Classes::TPersistent
{
	typedef System::Classes::TPersistent inherited;
	
private:
	bool FEnabled;
	System::Classes::THelpContext FHelpContext;
	Vcl::Controls::TCaption FTitle;
	System::UnicodeString FDescription;
	Vcl::Graphics::TPicture* FPicture;
	Vcl::Graphics::TIcon* FIcon;
	Vcl::Graphics::TPicture* __fastcall GetPicture();
	void __fastcall SetPicture(Vcl::Graphics::TPicture* Value);
	Vcl::Graphics::TIcon* __fastcall GetIcon();
	void __fastcall SetIcon(Vcl::Graphics::TIcon* Value);
	
public:
	__fastcall virtual TSMInetStatusDialog();
	__fastcall virtual ~TSMInetStatusDialog();
	virtual void __fastcall Assign(System::Classes::TPersistent* Source);
	
__published:
	__property bool Enabled = {read=FEnabled, write=FEnabled, default=0};
	__property System::Classes::THelpContext HelpContext = {read=FHelpContext, write=FHelpContext, default=0};
	__property Vcl::Graphics::TPicture* Picture = {read=GetPicture, write=SetPicture};
	__property Vcl::Graphics::TIcon* Icon = {read=GetIcon, write=SetIcon};
	__property Vcl::Controls::TCaption Title = {read=FTitle, write=FTitle};
	__property System::UnicodeString Description = {read=FDescription, write=FDescription};
};


class PASCALIMPLEMENTATION TSMCustomWebComponent : public System::Classes::TComponent
{
	typedef System::Classes::TComponent inherited;
	
private:
	System::UnicodeString FWEBAgent;
	System::Word FWEBPort;
	System::UnicodeString FWEBHost;
	System::UnicodeString FWEBUser;
	System::UnicodeString FWEBPassword;
	TSMIService FService;
	TSMIStatus FStatus;
	TSMIAction FAction;
	Sminbase::TSMInetProxy* FProxy;
	TSMInetStatusDialog* FStatusDialog;
	bool FLoginPrompt;
	bool FResumeDownload;
	TSMIProgress FOnProgress;
	System::Classes::TNotifyEvent FOnActionChange;
	System::Classes::TNotifyEvent FOnStatusChange;
	System::Classes::TNotifyEvent FOnBeforeExecute;
	System::Classes::TNotifyEvent FOnAfterExecute;
	void __fastcall SetProxy(Sminbase::TSMInetProxy* Value);
	void __fastcall SetStatusDialog(TSMInetStatusDialog* Value);
	void __fastcall SetStatus(TSMIStatus Value);
	void __fastcall SetAction(TSMIAction Value);
	void __fastcall SetService(TSMIService Value);
	
protected:
	void *hInet;
	void *hURL;
	void *hFindFile;
	Sminstat::TfrmSMInetUpdate* dlgStatus;
	virtual void __fastcall InternalExecute() = 0 ;
	void __fastcall UpdateProgress(unsigned BytesTotalRead, unsigned RemoteFileSize, bool &Abort);
	void __fastcall ConnectToInet(bool ToReadProxy);
	void __fastcall DisconnectFromInet();
	bool __fastcall GetFileInfoFromInet(const System::UnicodeString RemoteFileName, unsigned &RemoteFileSize, Winapi::Windows::TFileTime &RemoteFileCreated);
	bool __fastcall ReadFileFromInet(const System::UnicodeString RemoteFileName, const System::UnicodeString LocalFileName, unsigned RemoteFileSize);
	bool __fastcall ReadDirFromInet(const System::UnicodeString Directory, const System::UnicodeString WildCard, bool SubFolder, System::Classes::TStrings* lst);
	void __fastcall ReadHTTPGetResponse(const System::UnicodeString URL, System::Classes::TStream* AStream);
	System::UnicodeString __fastcall ReadHTTPGetResponseString(const System::UnicodeString URL);
	
public:
	__fastcall virtual TSMCustomWebComponent(System::Classes::TComponent* AOwner);
	__fastcall virtual ~TSMCustomWebComponent();
	virtual bool __fastcall Execute();
	__property TSMIAction Action = {read=FAction, write=SetAction, nodefault};
	__property TSMIStatus Status = {read=FStatus, write=SetStatus, nodefault};
	__property bool ResumeDownload = {read=FResumeDownload, write=FResumeDownload, default=0};
	
__published:
	__property System::UnicodeString Agent = {read=FWEBAgent, write=FWEBAgent};
	__property System::Word Port = {read=FWEBPort, write=FWEBPort, nodefault};
	__property TSMIService Service = {read=FService, write=SetService, default=0};
	__property System::UnicodeString Host = {read=FWEBHost, write=FWEBHost};
	__property System::UnicodeString User = {read=FWEBUser, write=FWEBUser};
	__property System::UnicodeString Password = {read=FWEBPassword, write=FWEBPassword};
	__property Sminbase::TSMInetProxy* Proxy = {read=FProxy, write=SetProxy};
	__property TSMInetStatusDialog* StatusDialog = {read=FStatusDialog, write=SetStatusDialog};
	__property bool LoginPrompt = {read=FLoginPrompt, write=FLoginPrompt, default=1};
	__property TSMIProgress OnProgress = {read=FOnProgress, write=FOnProgress};
	__property System::Classes::TNotifyEvent OnBeforeExecute = {read=FOnBeforeExecute, write=FOnBeforeExecute};
	__property System::Classes::TNotifyEvent OnAfterExecute = {read=FOnAfterExecute, write=FOnAfterExecute};
	__property System::Classes::TNotifyEvent OnActionChange = {read=FOnActionChange, write=FOnActionChange};
	__property System::Classes::TNotifyEvent OnStatusChange = {read=FOnStatusChange, write=FOnStatusChange};
};


typedef void __fastcall (__closure *TSMIFileCompare)(System::TObject* Sender, bool &Equal);

class PASCALIMPLEMENTATION TSMCustomWebUpdater : public TSMCustomWebComponent
{
	typedef TSMCustomWebComponent inherited;
	
private:
	unsigned FRemoteFileSize;
	Winapi::Windows::TFileTime FRemoteFileCreated;
	System::UnicodeString FRemoteFileName;
	System::UnicodeString FLocalFileName;
	TSMIFileCompare FOnFileCompare;
	
protected:
	virtual void __fastcall SetRemoteFileName(System::UnicodeString Value);
	__property System::UnicodeString LocalFileName = {read=FLocalFileName, write=FLocalFileName};
	
public:
	virtual void __fastcall InternalExecute();
	__property unsigned RemoteFileSize = {read=FRemoteFileSize, nodefault};
	__property Winapi::Windows::TFileTime RemoteFileCreated = {read=FRemoteFileCreated};
	
__published:
	__property System::UnicodeString RemoteFileName = {read=FRemoteFileName, write=SetRemoteFileName};
	__property TSMIFileCompare OnFileCompare = {read=FOnFileCompare, write=FOnFileCompare};
public:
	/* TSMCustomWebComponent.Create */ inline __fastcall virtual TSMCustomWebUpdater(System::Classes::TComponent* AOwner) : TSMCustomWebComponent(AOwner) { }
	/* TSMCustomWebComponent.Destroy */ inline __fastcall virtual ~TSMCustomWebUpdater() { }
	
};


class PASCALIMPLEMENTATION TSMWebUpdater : public TSMCustomWebUpdater
{
	typedef TSMCustomWebUpdater inherited;
	
__published:
	__property LocalFileName = {default=0};
public:
	/* TSMCustomWebComponent.Create */ inline __fastcall virtual TSMWebUpdater(System::Classes::TComponent* AOwner) : TSMCustomWebUpdater(AOwner) { }
	/* TSMCustomWebComponent.Destroy */ inline __fastcall virtual ~TSMWebUpdater() { }
	
};


//-- var, const, procedure ---------------------------------------------------
}	/* namespace Smiupdate */
#if !defined(DELPHIHEADER_NO_IMPLICIT_NAMESPACE_USE) && !defined(NO_USING_NAMESPACE_SMIUPDATE)
using namespace Smiupdate;
#endif
#pragma pack(pop)
#pragma option pop

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// smiupdateHPP
