unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, SMWhoIs, Grids, ComCtrls, ExtCtrls, scktcomp, SMInBase;

type
  TfrmWhoIs = class(TForm)
    gbWhoIs: TGroupBox;
    edDomain: TEdit;
    lblDomainName: TLabel;
    btnWhoIs: TButton;
    btnAbout: TButton;
    pcWhoIs: TPageControl;
    tsResults: TTabSheet;
    MemoWhoIs: TMemo;
    tsWhoIsServers: TTabSheet;
    sgServers: TStringGrid;
    tsOptions: TTabSheet;
    rbAutoSelectServer: TRadioButton;
    rbManualServer: TRadioButton;
    edServer: TEdit;
    lblWhoIsPort: TLabel;
    edWhoIsPort: TEdit;
    SMWhoIs: TSMWhoIs;
    pnlStatus: TPanel;
    lblURL: TLabel;
    imgLogo: TImage;
    rgClientType: TRadioGroup;
    procedure btnWhoIsClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lblURLClick(Sender: TObject);
    procedure SMWhoIsLookup(Sender: TObject; Socket: TCustomWinSocket);
    procedure SMWhoIsReceiveTextFromSocket(Sender: TObject; s: String);
    procedure SMWhoIsSendTextToSocket(Sender: TObject; s: String);
    procedure SMWhoIsConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure SMWhoIsConnecting(Sender: TObject; Socket: TCustomWinSocket);
    procedure SMWhoIsDisconnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure SMWhoIsError(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmWhoIs: TfrmWhoIs;

implementation

{$R *.DFM}
{$R winxp.res}

uses ShellAPI, SMInCnst;

procedure TfrmWhoIs.btnWhoIsClick(Sender: TObject);
var
  s, strWhoIs: string;
  i, intLen: Integer;
begin
  SMWhoIs.Port := StrToIntDef(edWhoIsPort.Text, SMWhoIs.Port);
  SMWhoIs.AutoSelectServer := rbAutoSelectServer.Checked;
  if rbManualServer.Checked then
    SMWhoIs.Host := edServer.Text;

  MemoWhoIs.Lines.Text := '';
  SMWhoIs.Domain := edDomain.Text;
  SMWhoIs.ClientType := TClientType(rgClientType.ItemIndex);

  s := SMWhoIs.Execute;
  intLen := Length(s);
  strWhoIs := '';
  for i := 1 to intLen do
  begin
    if (s[i] <> #10) or ((i = intLen) and (s[i] <> #10)) then
      strWhoIs := strWhoIs + s[i];

    if (s[i] = #10) or (i = intLen) then
    begin
      MemoWhoIs.Lines.Add(strWhoIs);
      strWhoIs := ''
    end
  end;
end;

procedure TfrmWhoIs.btnAboutClick(Sender: TObject);
begin
  AboutSMInet
end;

procedure TfrmWhoIs.FormCreate(Sender: TObject);
var
  i: Integer;
begin
  Application.Title := Caption;
  sgServers.Cells[0, 0] := 'Domain';
  sgServers.Cells[1, 0] := 'WhoIs server';

  for i := 0 to SMWhoIs.ServerList.Count-1 do
  begin
    sgServers.Cells[0, i+1] := SMWhoIs.ServerList.Names[i];
    sgServers.Cells[1, i+1] := SMWhoIs.ServerList.Values[SMWhoIs.ServerList.Names[i]];
  end;

  edServer.Text := DefaultWhoIsServer;
  edWhoIsPort.Text := IntToStr(SMWhoIs.Port);
  rgClientType.ItemIndex := Ord(SMWhoIs.ClientType)
end;

procedure TfrmWhoIs.lblURLClick(Sender: TObject);
begin
  ShellExecute(0, 'open', PChar((Sender as TLabel).Caption), nil, nil, SW_SHOWNORMAL);
end;

procedure TfrmWhoIs.SMWhoIsLookup(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  pnlStatus.Caption := 'Lookup...';
end;

procedure TfrmWhoIs.SMWhoIsReceiveTextFromSocket(Sender: TObject;
  s: String);
begin
  pnlStatus.Caption := 'Receiving information...';
end;

procedure TfrmWhoIs.SMWhoIsSendTextToSocket(Sender: TObject; s: String);
begin
  pnlStatus.Caption := 'Query sending...';
end;

procedure TfrmWhoIs.SMWhoIsConnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  pnlStatus.Caption := 'Connected.';
end;

procedure TfrmWhoIs.SMWhoIsConnecting(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  pnlStatus.Caption := 'Connecting...';
end;

procedure TfrmWhoIs.SMWhoIsDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  pnlStatus.Caption := 'Disconnected.';
end;

procedure TfrmWhoIs.SMWhoIsError(Sender: TObject; Socket: TCustomWinSocket;
  ErrorEvent: TErrorEvent; var ErrorCode: Integer);
begin
  MemoWhoIs.Lines.Add(IntToStr(ErrorCode) + ' ' + FormatDateTime('c', Now()))
end;

end.
