unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, scktcomp, SMInBase, SMITime, ExtCtrls;

type
  TfrmMain = class(TForm)
    gbOptions: TGroupBox;
    edServer: TEdit;
    lblHostName: TLabel;
    btnExecute: TButton;
    btnAbout: TButton;
    imgLogo: TImage;
    SMInetDateTime: TSMInetDateTime;
    lblPort: TLabel;
    edPort: TEdit;
    MemoResults: TMemo;
    bvl: TBevel;
    procedure btnExecuteClick(Sender: TObject);
    procedure SMWhoIsError(Sender: TObject; ErrorCode: Integer);
    procedure btnAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lblURLClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}
{$R winxp.res}

uses ShellAPI, SMInCnst;

procedure TfrmMain.btnExecuteClick(Sender: TObject);
begin
  SMInetDateTime.Port := StrToIntDef(edPort.Text, SMInetDateTime.Port);
  SMInetDateTime.Host := edServer.Text;

  MemoResults.Lines.Text := '';

  MemoResults.Lines.Add(FormatDateTime('dddd, mmmm dd, yyyy, tt ', SMInetDateTime.GetDateTime));
end;

procedure TfrmMain.SMWhoIsError(Sender: TObject; ErrorCode: Integer);
begin
  MemoResults.Lines.Add(IntToStr(ErrorCode) + ' ' + FormatDateTime('c', Now()))
end;

procedure TfrmMain.btnAboutClick(Sender: TObject);
begin
  AboutSMInet
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  Application.Title := Caption;

  edServer.Text := DefaultDTServer;
  edPort.Text := IntToStr(SMInetDateTime.Port);
end;

procedure TfrmMain.lblURLClick(Sender: TObject);
begin
  ShellExecute(0, 'open', PChar((Sender as TLabel).Caption), nil, nil, SW_SHOWNORMAL);
end;

end.
