unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, smidir, smiupdate;

type
  TfrmMain = class(TForm)
    gbOptions: TGroupBox;
    edHost: TEdit;
    lblHostName: TLabel;
    btnExecute: TButton;
    btnAbout: TButton;
    imgLogo: TImage;
    lblPort: TLabel;
    edPort: TEdit;
    pnlStatus: TPanel;
    lblURL: TLabel;
    lblUserID: TLabel;
    edUserID: TEdit;
    lblPassword: TLabel;
    edPassword: TEdit;
    lblFiles: TLabel;
    lblWEBSettings: TLabel;
    cbService: TComboBox;
    lblProgress: TLabel;
    lblWildcard: TLabel;
    cbWildcard: TComboBox;
    SMRemoteFiles: TSMRemoteFiles;
    cbSubFolders: TCheckBox;
    lbFiles: TListBox;
    procedure btnExecuteClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lblURLClick(Sender: TObject);
    procedure SMRemoteFilesAfterExecute(Sender: TObject);
    procedure SMRemoteFilesActionChange(Sender: TObject);
    procedure SMRemoteFilesStatusChange(Sender: TObject);
    procedure cbServiceChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}
{$R winxp.res}

uses ShellAPI, SMInCnst;

procedure TfrmMain.btnAboutClick(Sender: TObject);
begin
  AboutSMInet
end;

procedure TfrmMain.lblURLClick(Sender: TObject);
begin
  ShellExecute(0, 'open', PChar((Sender as TLabel).Caption), nil, nil, SW_SHOWNORMAL);
end;

procedure TfrmMain.btnExecuteClick(Sender: TObject);
begin
  SMRemoteFiles.Port := StrToIntDef(edPort.Text, SMRemoteFiles.Port);
  if (SMRemoteFiles.Service = isNetwork) then
    SMRemoteFiles.Directory := edHost.Text
  else
    SMRemoteFiles.Host := edHost.Text;
  SMRemoteFiles.User := edUserID.Text;
  SMRemoteFiles.Password := edPassword.Text;

  SMRemoteFiles.Wildcard := cbWildcard.Text;
  SMRemoteFiles.SubFolders := cbSubFolders.Checked;

  Screen.Cursor := crHourglass;
  try
    if SMRemoteFiles.Execute then
      lbFiles.Items.Assign(SMRemoteFiles.FileList);
  finally
    Screen.Cursor := crDefault;
  end
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  Application.Title := Caption;
  cbService.ItemIndex := Ord(SMRemoteFiles.Service);
  edHost.Text := SMRemoteFiles.Host;
  edPort.Text := IntToStr(SMRemoteFiles.Port);
  edUserID.Text := SMRemoteFiles.User;
  edPassword.Text := SMRemoteFiles.Password;

  cbSubFolders.Checked := SMRemoteFiles.SubFolders;
  cbWildcard.Text := SMRemoteFiles.Wildcard;
end;

procedure TfrmMain.SMRemoteFilesAfterExecute(Sender: TObject);
var
  s: string;
begin
  case SMRemoteFiles.Status of
    isFinished: s := 'Remote structure is loaded in listbox succesfully';
    isFailed: s := 'Error is occured during online session.';
    isSkipped: s := 'URL is not found';
  else
    s := '';
  end;

  if (s <> '') then
    ShowMessage(s)
end;

procedure TfrmMain.SMRemoteFilesActionChange(Sender: TObject);
const
  arrAction: array[TSMIAction] of string = (
                'Idle',
                'Connecting...',
                'Connected.',
                'Disconnecting...',
                'Disconnected.',
                'File search...',
                'File found.',
                'Comparing...',
                'Compared.',
                'Downloading...',
                'Downloaded.');
begin
  lblProgress.Caption := arrAction[SMRemoteFiles.Action];

  Application.ProcessMessages
end;

procedure TfrmMain.SMRemoteFilesStatusChange(Sender: TObject);
const
  arrStatus: array[TSMIStatus] of string = (
             'In progress...',
             'Completed.',
             'Failed.',
             'Skipped',
             'Remote file is not found');
begin
  lblProgress.Caption := arrStatus[SMRemoteFiles.Status];

  Application.ProcessMessages
end;

procedure TfrmMain.cbServiceChange(Sender: TObject);
begin
  SMRemoteFiles.Service := TSMIService(cbService.ItemIndex);
  edPort.Text := IntToStr(SMRemoteFiles.Port);
end;

end.
