unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, SMInBase, SMIUPS, ComCtrls, ScktComp, SMIFedEx, Grids;

type
  TfrmMain = class(TForm)
    gbOptions: TGroupBox;
    btnExecute: TButton;
    btnAbout: TButton;
    lblPackage: TLabel;
    edPackage: TEdit;
    imgLogo: TImage;
    StatusBar: TStatusBar;
    SMFedExTracker: TSMFedExTracker;
    pcDetails: TPageControl;
    tsShipment: TTabSheet;
    tsActivity: TTabSheet;
    sgActivity: TStringGrid;
    sgShipment: TStringGrid;
    procedure btnExecuteClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure SMUPSTrackerConnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure SMUPSTrackerConnecting(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure SMUPSTrackerDisconnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure SMUPSTrackerError(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure SMUPSTrackerLookup(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure SMUPSTrackerReceiveTextFromSocket(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure SMUPSTrackerSendTextToSocket(Sender: TObject;
      Socket: TCustomWinSocket);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}
{$R winxp.res}

uses SMInCnst, SMIUtil;

procedure TfrmMain.btnExecuteClick(Sender: TObject);
var
  i: Integer;
begin
  {define a package number}
  SMFedExTracker.TrackingNumber := edPackage.Text;

  {track a package and show a results}
  SMFedExTracker.Execute;

  {copy details to string grids}
  {1. shipment details}
  sgShipment.RowCount := SMFedExTracker.ShipmentInfo.Count;
  for i := 0 to SMFedExTracker.ShipmentInfo.Count-1 do
  begin
    sgShipment.Cells[0, i] := GetColumn(SMFedExTracker.ShipmentInfo[i], 0, '=');
    sgShipment.Cells[1, i] := GetColumn(SMFedExTracker.ShipmentInfo[i], 1, '=');
  end;

  {2. activity records}
  sgActivity.RowCount := SMFedExTracker.Activity.Count;
  sgActivity.Cells[0, 0] := 'Date/Time';
  sgActivity.Cells[1, 0] := 'Status';
  sgActivity.Cells[2, 0] := 'Location';
  sgActivity.Cells[3, 0] := 'Comments';
  for i := 1 to SMFedExTracker.Activity.Count-1 do
  begin
    sgActivity.Cells[0, i] := GetColumn(SMFedExTracker.Activity[i], 0, '=') + ' ' +
                              GetColumn(SMFedExTracker.Activity[i], 1, '=');
    sgActivity.Cells[1, i] := GetColumn(SMFedExTracker.Activity[i], 2, '=');
    sgActivity.Cells[2, i] := GetColumn(SMFedExTracker.Activity[i], 3, '=');
    sgActivity.Cells[3, i] := GetColumn(SMFedExTracker.Activity[i], 4, '=');
  end;
end;

procedure TfrmMain.btnAboutClick(Sender: TObject);
begin
  AboutSMInet
end;

procedure TfrmMain.SMUPSTrackerConnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Connected.';
end;

procedure TfrmMain.SMUPSTrackerConnecting(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Connecting...';
end;

procedure TfrmMain.SMUPSTrackerDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Disconnected.';
end;

procedure TfrmMain.SMUPSTrackerError(Sender: TObject;
  Socket: TCustomWinSocket; ErrorEvent: TErrorEvent;
  var ErrorCode: Integer);
begin
  StatusBar.SimpleText := 'Error: ' + IntToStr(ErrorCode);
end;

procedure TfrmMain.SMUPSTrackerLookup(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Lookup...';
end;

procedure TfrmMain.SMUPSTrackerReceiveTextFromSocket(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Receiving...';
end;

procedure TfrmMain.SMUPSTrackerSendTextToSocket(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  StatusBar.SimpleText := 'Sending...';
end;

end.
