unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, smiupdate, ComCtrls, smixtract;

type
  TfrmMain = class(TForm)
    gbOptions: TGroupBox;
    edHost: TEdit;
    lblHostName: TLabel;
    btnExecute: TButton;
    btnAbout: TButton;
    imgLogo: TImage;
    lblPort: TLabel;
    edPort: TEdit;
    MemoResults: TMemo;
    pnlStatus: TPanel;
    lblURL: TLabel;
    SMInfoExtractor: TSMInfoExtractor;
    lblUserID: TLabel;
    edUserID: TEdit;
    lblPassword: TLabel;
    edPassword: TEdit;
    lblFiles: TLabel;
    edRemoteFileName: TEdit;
    lblWEBSettings: TLabel;
    cbService: TComboBox;
    lblProgress: TLabel;
    pbStatus: TProgressBar;
    lblExtract: TLabel;
    cbExtract: TComboBox;
    procedure btnExecuteClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure lblURLClick(Sender: TObject);
    procedure SMInfoExtractorProgress(Sender: TObject; CurValue,
      MaxValue: Integer; var Abort: Boolean);
    procedure SMInfoExtractorAfterExecute(Sender: TObject);
    procedure SMInfoExtractorBeforeExecute(Sender: TObject);
    procedure SMInfoExtractorActionChange(Sender: TObject);
    procedure SMInfoExtractorStatusChange(Sender: TObject);
    procedure cbServiceChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}
{$R winxp.res}

uses ShellAPI, SMInCnst;

procedure TfrmMain.btnAboutClick(Sender: TObject);
begin
  AboutSMInet
end;

procedure TfrmMain.lblURLClick(Sender: TObject);
begin
  ShellExecute(0, 'open', PChar((Sender as TLabel).Caption), nil, nil, SW_SHOWNORMAL);
end;

procedure TfrmMain.btnExecuteClick(Sender: TObject);
begin
  SMInfoExtractor.Port := StrToIntDef(edPort.Text, SMInfoExtractor.Port);
  SMInfoExtractor.Host := edHost.Text;
  SMInfoExtractor.User := edUserID.Text;
  SMInfoExtractor.Password := edPassword.Text;
  SMInfoExtractor.Extract := TSMIExtract(cbExtract.ItemIndex);

  SMInfoExtractor.RemoteFileName := edRemoteFileName.Text;

  if SMInfoExtractor.Execute then
    MemoResults.Lines.Assign(SMInfoExtractor.ExtractedInfo)
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  Application.Title := Caption;

  cbService.ItemIndex := Ord(SMInfoExtractor.Service);
  edHost.Text := SMInfoExtractor.Host;
  edPort.Text := IntToStr(SMInfoExtractor.Port);
  edUserID.Text := SMInfoExtractor.User;
  edPassword.Text := SMInfoExtractor.Password;
  cbExtract.ItemIndex := Ord(SMInfoExtractor.Extract);

  edRemoteFileName.Text := SMInfoExtractor.RemoteFileName;
end;

procedure TfrmMain.SMInfoExtractorProgress(Sender: TObject; CurValue,
  MaxValue: Integer; var Abort: Boolean);
begin
  pbStatus.Max := MaxValue;
  pbStatus.Position := CurValue;
  lblProgress.Caption := 'Downloaded ' + IntToStr(CurValue) + ' of ' + IntToStr(MaxValue) + ' bytes (' + IntToStr(CurValue*100 div MaxValue) + '%)';

  Application.ProcessMessages
end;

procedure TfrmMain.SMInfoExtractorAfterExecute(Sender: TObject);
var
  s: string;
begin
  pbStatus.Visible := False;
  
  case SMInfoExtractor.Status of
    isFinished: s := 'File is processed succesfully';
    isFailed: s := 'Error is occured during file processing.';
    isSkipped: s := 'File is skipped or not found';
  else
    s := '';
  end;

  if (s <> '') then
    ShowMessage(s)
end;

procedure TfrmMain.SMInfoExtractorBeforeExecute(Sender: TObject);
begin
  pbStatus.Visible := True;
  pbStatus.Position := 0;

  Application.ProcessMessages
end;

procedure TfrmMain.SMInfoExtractorActionChange(Sender: TObject);
const
  arrAction: array[TSMIAction] of string = (
                'Idle',
                'Connecting...',
                'Connected.',
                'Disconnecting...',
                'Disconnected.',
                'File search...',
                'File found.',
                'Comparing...',
                'Compared.',
                'Downloading...',
                'Downloaded.');
begin
  lblProgress.Caption := arrAction[SMInfoExtractor.Action];

  Application.ProcessMessages
end;

procedure TfrmMain.SMInfoExtractorStatusChange(Sender: TObject);
const
  arrStatus: array[TSMIStatus] of string = (
             'In progress...',
             'Completed.',
             'Failed.',
             'Skipped',
             'Remote file is not found');
begin
  lblProgress.Caption := arrStatus[SMInfoExtractor.Status];

  Application.ProcessMessages
end;

procedure TfrmMain.cbServiceChange(Sender: TObject);
begin
  SMInfoExtractor.Service := TSMIService(cbService.ItemIndex);
  edPort.Text := IntToStr(SMInfoExtractor.Port);
end;


end.
